/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.function.ThrowableLongConsumer;

public interface LongConsumer {
    public void accept(long var1);

    public static class Util {
        private Util() {
        }

        public static LongConsumer andThen(final LongConsumer c1, final LongConsumer c2) {
            return new LongConsumer(){

                @Override
                public void accept(long value) {
                    c1.accept(value);
                    c2.accept(value);
                }
            };
        }

        public static LongConsumer safe(ThrowableLongConsumer<Throwable> throwableConsumer) {
            return Util.safe(throwableConsumer, null);
        }

        public static LongConsumer safe(final ThrowableLongConsumer<Throwable> throwableConsumer, final LongConsumer onFailedConsumer) {
            return new LongConsumer(){

                @Override
                public void accept(long value) {
                    block2: {
                        try {
                            throwableConsumer.accept(value);
                        }
                        catch (Throwable ex) {
                            if (onFailedConsumer == null) break block2;
                            onFailedConsumer.accept(value);
                        }
                    }
                }
            };
        }
    }
}

