/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api;

import com.apollographql.apollo3.api.BPossibleTypes;
import com.apollographql.apollo3.api.BTerm;
import com.apollographql.apollo3.api.BVariable;
import com.apollographql.apollo3.api.BooleanExpression;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\u001a;\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u001e\u0010\u0004\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u0005\"\b\u0012\u0004\u0012\u0002H\u00020\u0001\u00a2\u0006\u0002\u0010\u0006\u001a$\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\u001a;\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u001e\u0010\u0004\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u0005\"\b\u0012\u0004\u0012\u0002H\u00020\u0001\u00a2\u0006\u0002\u0010\u0006\u001a%\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0005\"\u00020\f\u00a2\u0006\u0002\u0010\r\u001a\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00012\u0006\u0010\u0010\u001a\u00020\f\u001aE\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u001e\u0010\u0004\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u0005\"\b\u0012\u0004\u0012\u0002H\u00020\u0001\u00a2\u0006\u0002\u0010\u0011\u001a\u001a\u0010\u0012\u001a\u00020\u0013\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u0001\u001a.\u0010\u0014\u001a\u00020\u0013\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00130\u0016\u001a(\u0010\u0014\u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020\u00170\u00012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\f\u001aE\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u001e\u0010\u0004\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u0005\"\b\u0012\u0004\u0012\u0002H\u00020\u0001\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u001b"}, d2={"and", "Lcom/apollographql/apollo3/api/BooleanExpression;", "T", "", "other", "", "([Lcom/apollographql/apollo3/api/BooleanExpression;)Lcom/apollographql/apollo3/api/BooleanExpression;", "not", "or", "possibleTypes", "Lcom/apollographql/apollo3/api/BPossibleTypes;", "typenames", "", "([Ljava/lang/String;)Lcom/apollographql/apollo3/api/BooleanExpression;", "variable", "Lcom/apollographql/apollo3/api/BVariable;", "name", "(Lcom/apollographql/apollo3/api/BooleanExpression;[Lcom/apollographql/apollo3/api/BooleanExpression;)Lcom/apollographql/apollo3/api/BooleanExpression;", "containsPossibleTypes", "", "evaluate", "block", "Lkotlin/Function1;", "Lcom/apollographql/apollo3/api/BTerm;", "variables", "", "typename", "apollo-api"})
@JvmName(name="BooleanExpressions")
public final class BooleanExpressions {
    @NotNull
    public static final <T> BooleanExpression<T> or(@NotNull BooleanExpression<? extends T> $this$or, BooleanExpression<? extends T> ... other) {
        Intrinsics.checkNotNullParameter($this$or, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return new BooleanExpression.Or(CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)ArraysKt.toList((Object[])other), $this$or)));
    }

    @NotNull
    public static final <T> BooleanExpression<T> and(@NotNull BooleanExpression<? extends T> $this$and, BooleanExpression<? extends T> ... other) {
        Intrinsics.checkNotNullParameter($this$and, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return new BooleanExpression.And(CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)ArraysKt.toList((Object[])other), $this$and)));
    }

    @NotNull
    public static final <T> BooleanExpression<T> or(BooleanExpression<? extends T> ... other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return new BooleanExpression.Or(CollectionsKt.toSet((Iterable)ArraysKt.toList((Object[])other)));
    }

    @NotNull
    public static final <T> BooleanExpression<T> and(BooleanExpression<? extends T> ... other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return new BooleanExpression.And(CollectionsKt.toSet((Iterable)ArraysKt.toList((Object[])other)));
    }

    @NotNull
    public static final <T> BooleanExpression<T> not(@NotNull BooleanExpression<? extends T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return new BooleanExpression.Not<T>(other);
    }

    @NotNull
    public static final BooleanExpression<BVariable> variable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new BooleanExpression.Element<BVariable>(new BVariable(name));
    }

    @NotNull
    public static final BooleanExpression<BPossibleTypes> possibleTypes(String ... typenames) {
        Intrinsics.checkNotNullParameter((Object)typenames, (String)"typenames");
        return new BooleanExpression.Element<BPossibleTypes>(new BPossibleTypes(ArraysKt.toSet((Object[])typenames)));
    }

    public static final <T> boolean evaluate(@NotNull BooleanExpression<? extends T> $this$evaluate, @NotNull Function1<? super T, Boolean> block) {
        boolean bl;
        block18: {
            Intrinsics.checkNotNullParameter($this$evaluate, (String)"<this>");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            BooleanExpression<? extends T> booleanExpression = $this$evaluate;
            if (Intrinsics.areEqual(booleanExpression, (Object)BooleanExpression.True.INSTANCE)) {
                bl = true;
            } else if (Intrinsics.areEqual(booleanExpression, (Object)BooleanExpression.False.INSTANCE)) {
                bl = false;
            } else if (booleanExpression instanceof BooleanExpression.Not) {
                bl = !BooleanExpressions.evaluate(((BooleanExpression.Not)$this$evaluate).getOperand(), block);
            } else if (booleanExpression instanceof BooleanExpression.Or) {
                Iterable $this$any$iv = ((BooleanExpression.Or)$this$evaluate).getOperands();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BooleanExpression it = (BooleanExpression)element$iv;
                        boolean bl2 = false;
                        if (!BooleanExpressions.evaluate(it, block)) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
            } else if (booleanExpression instanceof BooleanExpression.And) {
                Iterable $this$all$iv = ((BooleanExpression.And)$this$evaluate).getOperands();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        BooleanExpression it = (BooleanExpression)element$iv;
                        boolean bl3 = false;
                        if (BooleanExpressions.evaluate(it, block)) continue;
                        bl = false;
                        break block18;
                    }
                    bl = true;
                }
            } else if (booleanExpression instanceof BooleanExpression.Element) {
                bl = (Boolean)block.invoke(((BooleanExpression.Element)$this$evaluate).getValue());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static final boolean evaluate(@NotNull BooleanExpression<? extends BTerm> $this$evaluate, @NotNull Set<String> variables, @Nullable String typename) {
        Intrinsics.checkNotNullParameter($this$evaluate, (String)"<this>");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return BooleanExpressions.evaluate($this$evaluate, (Function1)new Function1<BTerm, Boolean>(variables, typename){
            final /* synthetic */ Set<String> $variables;
            final /* synthetic */ String $typename;
            {
                this.$variables = $variables;
                this.$typename = $typename;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull BTerm it) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                BTerm bTerm = it;
                if (bTerm instanceof BVariable) {
                    bl = this.$variables.contains(((BVariable)it).getName());
                } else if (bTerm instanceof BPossibleTypes) {
                    bl = CollectionsKt.contains((Iterable)((BPossibleTypes)it).getPossibleTypes(), (Object)this.$typename);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return bl;
            }
        });
    }

    public static final <T> boolean containsPossibleTypes(@NotNull BooleanExpression<? extends T> $this$containsPossibleTypes) {
        boolean bl;
        block18: {
            Intrinsics.checkNotNullParameter($this$containsPossibleTypes, (String)"<this>");
            BooleanExpression<? extends T> booleanExpression = $this$containsPossibleTypes;
            if (Intrinsics.areEqual(booleanExpression, (Object)BooleanExpression.True.INSTANCE)) {
                bl = false;
            } else if (Intrinsics.areEqual(booleanExpression, (Object)BooleanExpression.False.INSTANCE)) {
                bl = false;
            } else if (booleanExpression instanceof BooleanExpression.Not) {
                bl = BooleanExpressions.containsPossibleTypes(((BooleanExpression.Not)$this$containsPossibleTypes).getOperand());
            } else if (booleanExpression instanceof BooleanExpression.Or) {
                Iterable $this$any$iv = ((BooleanExpression.Or)$this$containsPossibleTypes).getOperands();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BooleanExpression it = (BooleanExpression)element$iv;
                        boolean bl2 = false;
                        if (!BooleanExpressions.containsPossibleTypes(it)) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
            } else if (booleanExpression instanceof BooleanExpression.And) {
                Iterable $this$any$iv = ((BooleanExpression.And)$this$containsPossibleTypes).getOperands();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BooleanExpression it = (BooleanExpression)element$iv;
                        boolean bl3 = false;
                        if (!BooleanExpressions.containsPossibleTypes(it)) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
            } else if (booleanExpression instanceof BooleanExpression.Element) {
                bl = ((BooleanExpression.Element)$this$containsPossibleTypes).getValue() instanceof BPossibleTypes;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }
}

