package com.spun.util;

import java.awt.Color;
import java.util.Random;

/**
 * Every color under the
 * <p style="color:red">r</p><p style="color:yellow">a</p><p style="color:orange">i</p><p style="color:green">n</p><p style="color:blue">b</p><p style="color:purple">o</p><p style="color:blue">w</p>,
 * and different ways to get them.
 */
public class Colors
{
  public static class Blues
  {
    /**
     * The color <p style="color:#000080"> Navy </p>
     **/
    public static final Color Navy            = Color.decode("#000080");
    /**
     * The color <p style="color:#00008B"> DarkBlue </p>
     **/
    public static final Color DarkBlue        = Color.decode("#00008B");
    /**
     * The color <p style="color:#191970"> MidnightBlue </p>
     **/
    public static final Color MidnightBlue    = Color.decode("#191970");
    /**
     * The color <p style="color:#0000CD"> MediumBlue </p>
     **/
    public static final Color MediumBlue      = Color.decode("#0000CD");
    /**
     * The color <p style="color:#0000FF"> Blue </p>
     **/
    public static final Color Blue            = Color.decode("#0000FF");
    /**
     * The color <p style="color:#008080"> Teal </p>
     **/
    public static final Color Teal            = Color.decode("#008080");
    /**
     * The color <p style="color:#483D8B"> DarkSlateBlue </p>
     **/
    public static final Color DarkSlateBlue   = Color.decode("#483D8B");
    /**
     * The color <p style="color:#008B8B"> DarkCyan </p>
     **/
    public static final Color DarkCyan        = Color.decode("#008B8B");
    /**
     * The color <p style="color:#4682B4"> SteelBlue </p>
     **/
    public static final Color SteelBlue       = Color.decode("#4682B4");
    /**
     * The color <p style="color:#4169E1"> RoyalBlue </p>
     **/
    public static final Color RoyalBlue       = Color.decode("#4169E1");
    /**
     * The color <p style="color:#6A5ACD"> SlateBlue </p>
     **/
    public static final Color SlateBlue       = Color.decode("#6A5ACD");
    /**
     * The color <p style="color:#5F9EA0"> CadetBlue </p>
     **/
    public static final Color CadetBlue       = Color.decode("#5F9EA0");
    /**
     * The color <p style="color:#00CED1"> DarkTurquoise </p>
     **/
    public static final Color DarkTurquoise   = Color.decode("#00CED1");
    /**
     * The color <p style="color:#1E90FF"> DodgerBlue </p>
     **/
    public static final Color DodgerBlue      = Color.decode("#1E90FF");
    /**
     * The color <p style="color:#00BFFF"> DeepSkyBlue </p>
     **/
    public static final Color DeepSkyBlue     = Color.decode("#00BFFF");
    /**
     * The color <p style="color:#7B68EE"> MediumSlateBlue </p>
     **/
    public static final Color MediumSlateBlue = Color.decode("#7B68EE");
    /**
     * The color <p style="color:#48D1CC"> MediumTurquoise </p>
     **/
    public static final Color MediumTurquoise = Color.decode("#48D1CC");
    /**
     * The color <p style="color:#6495ED"> CornflowerBlue </p>
     **/
    public static final Color CornflowerBlue  = Color.decode("#6495ED");
    /**
     * The color <p style="color:#40E0D0"> Turquoise </p>
     **/
    public static final Color Turquoise       = Color.decode("#40E0D0");
    /**
     * The color <p style="color:#00FFFF"> Aqua </p>
     **/
    public static final Color Aqua            = Color.decode("#00FFFF");
    /**
     * The color <p style="color:#00FFFF"> Cyan </p>
     **/
    public static final Color Cyan            = Color.decode("#00FFFF");
    /**
     * The color <p style="color:#87CEEB"> SkyBlue </p>
     **/
    public static final Color SkyBlue         = Color.decode("#87CEEB");
    /**
     * The color <p style="color:#87CEFA"> LightSkyBlue </p>
     **/
    public static final Color LightSkyBlue    = Color.decode("#87CEFA");
    /**
     * The color <p style="color:#7FFFD4"> Aquamarine </p>
     **/
    public static final Color Aquamarine      = Color.decode("#7FFFD4");
    /**
     * The color <p style="color:#B0C4DE"> LightSteelBlue </p>
     **/
    public static final Color LightSteelBlue  = Color.decode("#B0C4DE");
    /**
     * The color <p style="color:#ADD8E6"> LightBlue </p>
     **/
    public static final Color LightBlue       = Color.decode("#ADD8E6");
    /**
     * The color <p style="color:#B0E0E6"> PowderBlue </p>
     **/
    public static final Color PowderBlue      = Color.decode("#B0E0E6");
    /**
     * The color <p style="color:#AFEEEE"> PaleTurquoise </p>
     **/
    public static final Color PaleTurquoise   = Color.decode("#AFEEEE");
    /**
     * The color <p style="color:#E0FFFF"> LightCyan </p>
     **/
    public static final Color LightCyan       = Color.decode("#E0FFFF");
    /**
     * The color <p style="color:#F0F8FF"> AliceBlue </p>
     **/
    public static final Color AliceBlue       = Color.decode("#F0F8FF");
    /**
     * The color <p style="color:#F0FFFF"> Azure </p>
     **/
    public static final Color Azure           = Color.decode("#F0FFFF");
  }
  public static class Browns
  {
    /**
     * The color <p style="color:#800000"> Maroon </p>
     **/
    public static final Color Maroon         = Color.decode("#800000");
    /**
     * The color <p style="color:#8B4513"> SaddleBrown </p>
     **/
    public static final Color SaddleBrown    = Color.decode("#8B4513");
    /**
     * The color <p style="color:#A52A2A"> Brown </p>
     **/
    public static final Color Brown          = Color.decode("#A52A2A");
    /**
     * The color <p style="color:#A0522D"> Sienna </p>
     **/
    public static final Color Sienna         = Color.decode("#A0522D");
    /**
     * The color <p style="color:#B8860B"> DarkGoldenrod </p>
     **/
    public static final Color DarkGoldenrod  = Color.decode("#B8860B");
    /**
     * The color <p style="color:#D2691E"> Chocolate </p>
     **/
    public static final Color Chocolate      = Color.decode("#D2691E");
    /**
     * The color <p style="color:#CD853F"> Peru </p>
     **/
    public static final Color Peru           = Color.decode("#CD853F");
    /**
     * The color <p style="color:#DAA520"> Goldenrod </p>
     **/
    public static final Color Goldenrod      = Color.decode("#DAA520");
    /**
     * The color <p style="color:#BC8F8F"> RosyBrown </p>
     **/
    public static final Color RosyBrown      = Color.decode("#BC8F8F");
    /**
     * The color <p style="color:#F4A460"> SandyBrown </p>
     **/
    public static final Color SandyBrown     = Color.decode("#F4A460");
    /**
     * The color <p style="color:#D2B48C"> Tan </p>
     **/
    public static final Color Tan            = Color.decode("#D2B48C");
    /**
     * The color <p style="color:#DEB887"> BurlyWood </p>
     **/
    public static final Color BurlyWood      = Color.decode("#DEB887");
    /**
     * The color <p style="color:#F5DEB3"> Wheat </p>
     **/
    public static final Color Wheat          = Color.decode("#F5DEB3");
    /**
     * The color <p style="color:#FFDEAD"> NavajoWhite </p>
     **/
    public static final Color NavajoWhite    = Color.decode("#FFDEAD");
    /**
     * The color <p style="color:#FFE4C4"> Bisque </p>
     **/
    public static final Color Bisque         = Color.decode("#FFE4C4");
    /**
     * The color <p style="color:#FFEBCD"> BlanchedAlmond </p>
     **/
    public static final Color BlanchedAlmond = Color.decode("#FFEBCD");
    /**
     * The color <p style="color:#FFF8DC"> Cornsilk </p>
     **/
    public static final Color Cornsilk       = Color.decode("#FFF8DC");
  }
  public static class Grays
  {
    /**
     * The color <p style="color:#000000"> Black </p>
     **/
    public static final Color Black          = Color.decode("#000000");
    /**
     * The color <p style="color:#2F4F4F"> DarkSlateGray </p>
     **/
    public static final Color DarkSlateGray  = Color.decode("#2F4F4F");
    /**
     * The color <p style="color:#696969"> DimGray </p>
     **/
    public static final Color DimGray        = Color.decode("#696969");
    /**
     * The color <p style="color:#808080"> Gray </p>
     **/
    public static final Color Gray           = Color.decode("#808080");
    /**
     * The color <p style="color:#708090"> SlateGray </p>
     **/
    public static final Color SlateGray      = Color.decode("#708090");
    /**
     * The color <p style="color:#778899"> LightSlateGray </p>
     **/
    public static final Color LightSlateGray = Color.decode("#778899");
    /**
     * The color <p style="color:#A9A9A9"> DarkGray </p>
     **/
    public static final Color DarkGray       = Color.decode("#A9A9A9");
    /**
     * The color <p style="color:#C0C0C0"> Silver </p>
     **/
    public static final Color Silver         = Color.decode("#C0C0C0");
    /**
     * The color <p style="color:#D3D3D3"> LightGray </p>
     **/
    public static final Color LightGray      = Color.decode("#D3D3D3");
    /**
     * The color <p style="color:#DCDCDC"> Gainsboro </p>
     **/
    public static final Color Gainsboro      = Color.decode("#DCDCDC");
  }
  public static class Greens
  {
    /**
     * The color <p style="color:#006400"> DarkGreen </p>
     **/
    public static final Color DarkGreen         = Color.decode("#006400");
    /**
     * The color <p style="color:#008000"> Green </p>
     **/
    public static final Color Green             = Color.decode("#008000");
    /**
     * The color <p style="color:#228B22"> ForestGreen </p>
     **/
    public static final Color ForestGreen       = Color.decode("#228B22");
    /**
     * The color <p style="color:#556B2F"> DarkOliveGreen </p>
     **/
    public static final Color DarkOliveGreen    = Color.decode("#556B2F");
    /**
     * The color <p style="color:#00FF00"> Lime </p>
     **/
    public static final Color Lime              = Color.decode("#00FF00");
    /**
     * The color <p style="color:#808000"> Olive </p>
     **/
    public static final Color Olive             = Color.decode("#808000");
    /**
     * The color <p style="color:#008080"> Teal </p>
     **/
    public static final Color Teal              = Color.decode("#008080");
    /**
     * The color <p style="color:#2E8B57"> SeaGreen </p>
     **/
    public static final Color SeaGreen          = Color.decode("#2E8B57");
    /**
     * The color <p style="color:#008B8B"> DarkCyan </p>
     **/
    public static final Color DarkCyan          = Color.decode("#008B8B");
    /**
     * The color <p style="color:#6B8E23"> OliveDrab </p>
     **/
    public static final Color OliveDrab         = Color.decode("#6B8E23");
    /**
     * The color <p style="color:#32CD32"> LimeGreen </p>
     **/
    public static final Color LimeGreen         = Color.decode("#32CD32");
    /**
     * The color <p style="color:#3CB371"> MediumSeaGreen </p>
     **/
    public static final Color MediumSeaGreen    = Color.decode("#3CB371");
    /**
     * The color <p style="color:#7CFC00"> LawnGreen </p>
     **/
    public static final Color LawnGreen         = Color.decode("#7CFC00");
    /**
     * The color <p style="color:#20B2AA"> LightSeaGreen </p>
     **/
    public static final Color LightSeaGreen     = Color.decode("#20B2AA");
    /**
     * The color <p style="color:#7FFF00"> Chartreuse </p>
     **/
    public static final Color Chartreuse        = Color.decode("#7FFF00");
    /**
     * The color <p style="color:#00FF7F"> SpringGreen </p>
     **/
    public static final Color SpringGreen       = Color.decode("#00FF7F");
    /**
     * The color <p style="color:#00FA9A"> MediumSpringGreen </p>
     **/
    public static final Color MediumSpringGreen = Color.decode("#00FA9A");
    /**
     * The color <p style="color:#9ACD32"> YellowGreen </p>
     **/
    public static final Color YellowGreen       = Color.decode("#9ACD32");
    /**
     * The color <p style="color:#00CED1"> DarkTurquoise </p>
     **/
    public static final Color DarkTurquoise     = Color.decode("#00CED1");
    /**
     * The color <p style="color:#8FBC8F"> DarkSeaGreen </p>
     **/
    public static final Color DarkSeaGreen      = Color.decode("#8FBC8F");
    /**
     * The color <p style="color:#ADFF2F"> GreenYellow </p>
     **/
    public static final Color GreenYellow       = Color.decode("#ADFF2F");
    /**
     * The color <p style="color:#66CDAA"> MediumAquamarine </p>
     **/
    public static final Color MediumAquamarine  = Color.decode("#66CDAA");
    /**
     * The color <p style="color:#48D1CC"> MediumTurquoise </p>
     **/
    public static final Color MediumTurquoise   = Color.decode("#48D1CC");
    /**
     * The color <p style="color:#40E0D0"> Turquoise </p>
     **/
    public static final Color Turquoise         = Color.decode("#40E0D0");
    /**
     * The color <p style="color:#90EE90"> LightGreen </p>
     **/
    public static final Color LightGreen        = Color.decode("#90EE90");
    /**
     * The color <p style="color:#98FB98"> PaleGreen </p>
     **/
    public static final Color PaleGreen         = Color.decode("#98FB98");
    /**
     * The color <p style="color:#7FFFD4"> Aquamarine </p>
     **/
    public static final Color Aquamarine        = Color.decode("#7FFFD4");
    /**
     * The color <p style="color:#AFEEEE"> PaleTurquoise </p>
     **/
    public static final Color PaleTurquoise     = Color.decode("#AFEEEE");
  }
  public static class Oranges
  {
    /**
     * The color <p style="color:#FF4500"> OrangeRed </p>
     **/
    public static final Color OrangeRed   = Color.decode("#FF4500");
    /**
     * The color <p style="color:#FF8C00"> DarkOrange </p>
     **/
    public static final Color DarkOrange  = Color.decode("#FF8C00");
    /**
     * The color <p style="color:#FFA500"> Orange </p>
     **/
    public static final Color Orange      = Color.decode("#FFA500");
    /**
     * The color <p style="color:#FF6347"> Tomato </p>
     **/
    public static final Color Tomato      = Color.decode("#FF6347");
    /**
     * The color <p style="color:#FF7F50"> Coral </p>
     **/
    public static final Color Coral       = Color.decode("#FF7F50");
    /**
     * The color <p style="color:#FFA07A"> LightSalmon </p>
     **/
    public static final Color LightSalmon = Color.decode("#FFA07A");
  }
  public static class Pinks
  {
    /**
     * The color <p style="color:#C71585"> MediumVioletRed </p>
     **/
    public static final Color MediumVioletRed = Color.decode("#C71585");
    /**
     * The color <p style="color:#FF1493"> DeepPink </p>
     **/
    public static final Color DeepPink        = Color.decode("#FF1493");
    /**
     * The color <p style="color:#DB7093"> PaleVioletRed </p>
     **/
    public static final Color PaleVioletRed   = Color.decode("#DB7093");
    /**
     * The color <p style="color:#FF00FF"> Fuchsia </p>
     **/
    public static final Color Fuchsia         = Color.decode("#FF00FF");
    /**
     * The color <p style="color:#FF69B4"> HotPink </p>
     **/
    public static final Color HotPink         = Color.decode("#FF69B4");
    /**
     * The color <p style="color:#FFB6C1"> LightPink </p>
     **/
    public static final Color LightPink       = Color.decode("#FFB6C1");
    /**
     * The color <p style="color:#FFC0CB"> Pink </p>
     **/
    public static final Color Pink            = Color.decode("#FFC0CB");
  }
  public static class Purples
  {
    /**
     * The color <p style="color:#4B0082"> Indigo </p>
     **/
    public static final Color Indigo          = Color.decode("#4B0082");
    /**
     * The color <p style="color:#800080"> Purple </p>
     **/
    public static final Color Purple          = Color.decode("#800080");
    /**
     * The color <p style="color:#483D8B"> DarkSlateBlue </p>
     **/
    public static final Color DarkSlateBlue   = Color.decode("#483D8B");
    /**
     * The color <p style="color:#8B008B"> DarkMagenta </p>
     **/
    public static final Color DarkMagenta     = Color.decode("#8B008B");
    /**
     * The color <p style="color:#C71585"> MediumVioletRed </p>
     **/
    public static final Color MediumVioletRed = Color.decode("#C71585");
    /**
     * The color <p style="color:#9400D3"> DarkViolet </p>
     **/
    public static final Color DarkViolet      = Color.decode("#9400D3");
    /**
     * The color <p style="color:#6A5ACD"> SlateBlue </p>
     **/
    public static final Color SlateBlue       = Color.decode("#6A5ACD");
    /**
     * The color <p style="color:#8A2BE2"> BlueViolet </p>
     **/
    public static final Color BlueViolet      = Color.decode("#8A2BE2");
    /**
     * The color <p style="color:#9932CC"> DarkOrchid </p>
     **/
    public static final Color DarkOrchid      = Color.decode("#9932CC");
    /**
     * The color <p style="color:#7B68EE"> MediumSlateBlue </p>
     **/
    public static final Color MediumSlateBlue = Color.decode("#7B68EE");
    /**
     * The color <p style="color:#BC8F8F"> RosyBrown </p>
     **/
    public static final Color RosyBrown       = Color.decode("#BC8F8F");
    /**
     * The color <p style="color:#9370DB"> MediumPurple </p>
     **/
    public static final Color MediumPurple    = Color.decode("#9370DB");
    /**
     * The color <p style="color:#DB7093"> PaleVioletRed </p>
     **/
    public static final Color PaleVioletRed   = Color.decode("#DB7093");
    /**
     * The color <p style="color:#BA55D3"> MediumOrchid </p>
     **/
    public static final Color MediumOrchid    = Color.decode("#BA55D3");
    /**
     * The color <p style="color:#FF00FF"> Fuchsia </p>
     **/
    public static final Color Fuchsia         = Color.decode("#FF00FF");
    /**
     * The color <p style="color:#FF00FF"> Magenta </p>
     **/
    public static final Color Magenta         = Color.decode("#FF00FF");
    /**
     * The color <p style="color:#DA70D6"> Orchid </p>
     **/
    public static final Color Orchid          = Color.decode("#DA70D6");
    /**
     * The color <p style="color:#DDA0DD"> Plum </p>
     **/
    public static final Color Plum            = Color.decode("#DDA0DD");
    /**
     * The color <p style="color:#EE82EE"> Violet </p>
     **/
    public static final Color Violet          = Color.decode("#EE82EE");
    /**
     * The color <p style="color:#D8BFD8"> Thistle </p>
     **/
    public static final Color Thistle         = Color.decode("#D8BFD8");
    /**
     * The color <p style="color:#E6E6FA"> Lavender </p>
     **/
    public static final Color Lavender        = Color.decode("#E6E6FA");
  }
  public static class Reds
  {
    /**
     * The color <p style="color:#8B0000"> DarkRed </p>
     **/
    public static final Color DarkRed         = Color.decode("#8B0000");
    /**
     * The color <p style="color:#B22222"> FireBrick </p>
     **/
    public static final Color FireBrick       = Color.decode("#B22222");
    /**
     * The color <p style="color:#FF0000"> Red </p>
     **/
    public static final Color Red             = Color.decode("#FF0000");
    /**
     * The color <p style="color:#DC143C"> Crimson </p>
     **/
    public static final Color Crimson         = Color.decode("#DC143C");
    /**
     * The color <p style="color:#FF4500"> OrangeRed </p>
     **/
    public static final Color OrangeRed       = Color.decode("#FF4500");
    /**
     * The color <p style="color:#C71585"> MediumVioletRed </p>
     **/
    public static final Color MediumVioletRed = Color.decode("#C71585");
    /**
     * The color <p style="color:#CD5C5C"> IndianRed </p>
     **/
    public static final Color IndianRed       = Color.decode("#CD5C5C");
    /**
     * The color <p style="color:#FF6347"> Tomato </p>
     **/
    public static final Color Tomato          = Color.decode("#FF6347");
    /**
     * The color <p style="color:#DB7093"> PaleVioletRed </p>
     **/
    public static final Color PaleVioletRed   = Color.decode("#DB7093");
    /**
     * The color <p style="color:#FA8072"> Salmon </p>
     **/
    public static final Color Salmon          = Color.decode("#FA8072");
    /**
     * The color <p style="color:#F08080"> LightCoral </p>
     **/
    public static final Color LightCoral      = Color.decode("#F08080");
    /**
     * The color <p style="color:#E9967A"> DarkSalmon </p>
     **/
    public static final Color DarkSalmon      = Color.decode("#E9967A");
    /**
     * The color <p style="color:#FFA07A"> LightSalmon </p>
     **/
    public static final Color LightSalmon     = Color.decode("#FFA07A");
  }
  public static class Whites
  {
    /**
     * The color <p style="color:#FAEBD7"> AntiqueWhite </p>
     **/
    public static final Color AntiqueWhite  = Color.decode("#FAEBD7");
    /**
     * The color <p style="color:#FFE4E1"> MistyRose </p>
     **/
    public static final Color MistyRose     = Color.decode("#FFE4E1");
    /**
     * The color <p style="color:#F5F5DC"> Beige </p>
     **/
    public static final Color Beige         = Color.decode("#F5F5DC");
    /**
     * The color <p style="color:#FAF0E6"> Linen </p>
     **/
    public static final Color Linen         = Color.decode("#FAF0E6");
    /**
     * The color <p style="color:#FDF5E6"> OldLace </p>
     **/
    public static final Color OldLace       = Color.decode("#FDF5E6");
    /**
     * The color <p style="color:#F0FFF0"> Honeydew </p>
     **/
    public static final Color Honeydew      = Color.decode("#F0FFF0");
    /**
     * The color <p style="color:#F5F5F5"> WhiteSmoke </p>
     **/
    public static final Color WhiteSmoke    = Color.decode("#F5F5F5");
    /**
     * The color <p style="color:#FFF5EE"> Seashell </p>
     **/
    public static final Color Seashell      = Color.decode("#FFF5EE");
    /**
     * The color <p style="color:#FFF0F5"> LavenderBlush </p>
     **/
    public static final Color LavenderBlush = Color.decode("#FFF0F5");
    /**
     * The color <p style="color:#F0F8FF"> AliceBlue </p>
     **/
    public static final Color AliceBlue     = Color.decode("#F0F8FF");
    /**
     * The color <p style="color:#FFFAF0"> FloralWhite </p>
     **/
    public static final Color FloralWhite   = Color.decode("#FFFAF0");
    /**
     * The color <p style="color:#F5FFFA"> MintCream </p>
     **/
    public static final Color MintCream     = Color.decode("#F5FFFA");
    /**
     * The color <p style="color:#F0FFFF"> Azure </p>
     **/
    public static final Color Azure         = Color.decode("#F0FFFF");
    /**
     * The color <p style="color:#FFFFF0"> Ivory </p>
     **/
    public static final Color Ivory         = Color.decode("#FFFFF0");
    /**
     * The color <p style="color:#F8F8FF"> GhostWhite </p>
     **/
    public static final Color GhostWhite    = Color.decode("#F8F8FF");
    /**
     * The color <p style="color:#FFFAFA"> Snow </p>
     **/
    public static final Color Snow          = Color.decode("#FFFAFA");
    /**
     * The color <p style="color:#FFFFFF"> White </p>
     **/
    public static final Color White         = Color.decode("#FFFFFF");
  }
  public static class Yellows
  {
    /**
     * The color <p style="color:#B8860B"> DarkGoldenrod </p>
     **/
    public static final Color DarkGoldenrod        = Color.decode("#B8860B");
    /**
     * The color <p style="color:#DAA520"> Goldenrod </p>
     **/
    public static final Color Goldenrod            = Color.decode("#DAA520");
    /**
     * The color <p style="color:#FFD700"> Gold </p>
     **/
    public static final Color Gold                 = Color.decode("#FFD700");
    /**
     * The color <p style="color:#BDB76B"> DarkKhaki </p>
     **/
    public static final Color DarkKhaki            = Color.decode("#BDB76B");
    /**
     * The color <p style="color:#FFFF00"> Yellow </p>
     **/
    public static final Color Yellow               = Color.decode("#FFFF00");
    /**
     * The color <p style="color:#F0E68C"> Khaki </p>
     **/
    public static final Color Khaki                = Color.decode("#F0E68C");
    /**
     * The color <p style="color:#EEE8AA"> PaleGoldenrod </p>
     **/
    public static final Color PaleGoldenrod        = Color.decode("#EEE8AA");
    /**
     * The color <p style="color:#FFDAB9"> PeachPuff </p>
     **/
    public static final Color PeachPuff            = Color.decode("#FFDAB9");
    /**
     * The color <p style="color:#FFE4B5"> Moccasin </p>
     **/
    public static final Color Moccasin             = Color.decode("#FFE4B5");
    /**
     * The color <p style="color:#FFEFD5"> PapayaWhip </p>
     **/
    public static final Color PapayaWhip           = Color.decode("#FFEFD5");
    /**
     * The color <p style="color:#FFFACD"> LemonChiffon </p>
     **/
    public static final Color LemonChiffon         = Color.decode("#FFFACD");
    /**
     * The color <p style="color:#FAFAD2"> LightGoldenrodYellow </p>
     **/
    public static final Color LightGoldenrodYellow = Color.decode("#FAFAD2");
    /**
     * The color <p style="color:#FFFFE0"> LightYellow </p>
     **/
    public static final Color LightYellow          = Color.decode("#FFFFE0");
  }
  private static Random RANDOM = new Random();
  public static Color darken(Color color)
  {
    int red = decrease(color.getRed(), 10);
    int green = decrease(color.getGreen(), 10);
    int blue = decrease(color.getBlue(), 10);
    return new Color(red, green, blue);
  }

  private static int decrease(int amount, int decreaseBy)
  {
    return Math.max(0, amount - decreaseBy);
  }

  public static Color lighten(Color color)
  {
    int red = increase(color.getRed(), 10);
    int green = increase(color.getGreen(), 10);
    int blue = increase(color.getBlue(), 10);
    return new Color(red, green, blue);
  }

  private static int increase(int amount, int increaseBy)
  {
    return Math.min(255, amount + increaseBy);
  }

  public static Color getRandomColor()
  {
    return new Color(RANDOM.nextInt(255), RANDOM.nextInt(255), RANDOM.nextInt(255));
  }

  public static void mockRandom()
  {
    RANDOM.setSeed(5);
  }

  public static int calculateTransparency(int percentTransparent)
  {
    int opacity = (percentTransparent * 255) / 100;
    return (255 - opacity);
  }

  public static Color getTransparentVersion(Color color, int percentTransparency)
  {
    return new Color(color.getRed(), color.getGreen(), color.getBlue(),
        calculateTransparency(percentTransparency));
  }
}