/*
 * Decompiled with CFR 0.152.
 */
package com.asquera.elasticsearch.plugins.http;

import com.asquera.elasticsearch.plugins.http.HttpBasicServer;
import com.asquera.elasticsearch.plugins.http.HttpBasicServerModule;
import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.AbstractPlugin;

public class HttpBasicServerPlugin
extends AbstractPlugin {
    private boolean enabledByDefault = true;
    private final Settings settings;

    @Inject
    public HttpBasicServerPlugin(Settings settings) {
        this.settings = settings;
    }

    public String name() {
        return "http-basic-server-plugin";
    }

    public String description() {
        return "HTTP Basic Server Plugin";
    }

    public Collection<Class<? extends Module>> modules() {
        ArrayList modules = Lists.newArrayList();
        if (this.settings.getAsBoolean("http.basic.enabled", Boolean.valueOf(this.enabledByDefault)).booleanValue()) {
            modules.add(HttpBasicServerModule.class);
        }
        return modules;
    }

    public Collection<Class<? extends LifecycleComponent>> services() {
        ArrayList services = Lists.newArrayList();
        if (this.settings.getAsBoolean("http.basic.enabled", Boolean.valueOf(this.enabledByDefault)).booleanValue()) {
            services.add(HttpBasicServer.class);
        }
        return services;
    }

    public Settings additionalSettings() {
        if (this.settings.getAsBoolean("http.basic.enabled", Boolean.valueOf(this.enabledByDefault)).booleanValue()) {
            return ImmutableSettings.settingsBuilder().put("http.enabled", false).build();
        }
        return ImmutableSettings.Builder.EMPTY_SETTINGS;
    }
}

