/*
 * Decompiled with CFR 0.152.
 */
package com.asquera.elasticsearch.plugins.http.auth;

import com.asquera.elasticsearch.plugins.http.auth.ProxyChain;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ProxyChains {
    private Set<ProxyChain> proxyChains;

    public ProxyChains(Set<ProxyChain> proxyChains) {
        this.proxyChains = proxyChains;
    }

    public ProxyChains(String[] proxyChains) {
        this(ProxyChains.getProxies(proxyChains));
    }

    public Boolean trusts(ProxyChain candidate) {
        return this.trustedSubchain(candidate) != null;
    }

    public ProxyChain trustedSubchain(ProxyChain candidate) {
        Set<ProxyChain> sub = this.subchains();
        sub.retainAll(candidate.subchains().getProxyChains());
        ProxyChain trusted = null;
        if (!sub.isEmpty()) {
            trusted = Collections.max(sub, new InetAddressChainComparator());
        }
        return trusted;
    }

    public Set<ProxyChain> subchains() {
        Iterator<ProxyChain> iterator = this.proxyChains.iterator();
        HashSet<ProxyChain> set = new HashSet<ProxyChain>();
        while (iterator.hasNext()) {
            ProxyChain next = iterator.next();
            set.addAll(next.subchains().getProxyChains());
        }
        return set;
    }

    public boolean contains(Object c) {
        return this.proxyChains.contains(c);
    }

    public boolean isEmpty() {
        return this.proxyChains.isEmpty();
    }

    public boolean add(ProxyChain chain) {
        return this.proxyChains.add(chain);
    }

    public String toString() {
        return this.proxyChains.toString();
    }

    private static Set<ProxyChain> getProxies(String[] ips) {
        HashSet<ProxyChain> pChainSet = new HashSet<ProxyChain>();
        for (String next : Arrays.asList(ips)) {
            pChainSet.add(new ProxyChain(next));
        }
        return pChainSet;
    }

    public Set<ProxyChain> getProxyChains() {
        return this.proxyChains;
    }

    class InetAddressChainComparator
    implements Comparator<ProxyChain> {
        InetAddressChainComparator() {
        }

        @Override
        public int compare(ProxyChain a, ProxyChain b) {
            return a.size() < b.size() ? -1 : (a.size() == b.size() ? 0 : 1);
        }
    }
}

