/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.logging.log4j;

import com.atlassian.logging.log4j.CategoryCollapsingPatternParser;
import com.atlassian.logging.log4j.LogMessageUtil;
import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.spi.LoggingEvent;

public class NewLineLogMessagePatternParser
extends CategoryCollapsingPatternParser {
    private String lineIndent;

    public NewLineLogMessagePatternParser(String pattern, String lineIndent, int fqNameCollapsePrecision) {
        super(pattern, fqNameCollapsePrecision);
        this.lineIndent = lineIndent;
    }

    @Override
    protected void finalizeConverter(char c) {
        switch (c) {
            case 'm': {
                this.addConverter(new LineEndingStrippingPatternConverter(this.formattingInfo, this.lineIndent));
                break;
            }
            default: {
                super.finalizeConverter(c);
            }
        }
    }

    protected static class LineEndingStrippingPatternConverter
    extends PatternConverter {
        private final String lineIndent;

        LineEndingStrippingPatternConverter(FormattingInfo info, String lineIndent) {
            super(info);
            this.lineIndent = lineIndent;
        }

        public String convert(LoggingEvent event) {
            return LogMessageUtil.appendLineIndent(event.getRenderedMessage(), this.lineIndent);
        }
    }
}

