/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.compat.delegate;

import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheSettingsMapper {
    static final Logger LOG = LoggerFactory.getLogger(CacheSettingsMapper.class);

    private CacheSettingsMapper() {
    }

    static CacheSettings mapCacheSettings(com.atlassian.cache.compat.CacheSettings compatCacheSettings) {
        if (compatCacheSettings == null) {
            return null;
        }
        CacheSettingsBuilder builder = new CacheSettingsBuilder();
        CacheSettingsMapper.applyExpireAfterAccess(builder, compatCacheSettings.getExpireAfterAccess());
        CacheSettingsMapper.applyExpireAfterWrite(builder, compatCacheSettings.getExpireAfterWrite());
        CacheSettingsMapper.applyFlushable(builder, compatCacheSettings.getFlushable());
        CacheSettingsMapper.applyLocal(builder, compatCacheSettings.getLocal());
        CacheSettingsMapper.applyMaxEntries(builder, compatCacheSettings.getMaxEntries());
        CacheSettingsMapper.applyReplicateAsynchronously(builder, compatCacheSettings.getReplicateAsynchronously());
        CacheSettingsMapper.applyReplicateViaCopy(builder, compatCacheSettings.getReplicateViaCopy());
        return builder.build();
    }

    private static void applyUsingReflection(CacheSettingsBuilder builder, String methodName) {
        try {
            builder.getClass().getMethod(methodName, new Class[0]).invoke((Object)builder, new Object[0]);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to apply explicit {} setting.", (Object)methodName, (Object)e);
            }
            LOG.warn("Unable to apply explicit {} setting.  Enable DEBUG logging for a stack trace.", (Object)methodName);
        }
    }

    private static void applyReplicateViaCopy(CacheSettingsBuilder builder, Boolean replicateViaCopy) {
        if (replicateViaCopy != null) {
            if (replicateViaCopy.booleanValue()) {
                builder.replicateViaCopy();
            } else {
                CacheSettingsMapper.applyUsingReflection(builder, "replicateViaInvalidation");
            }
        }
    }

    private static void applyReplicateAsynchronously(CacheSettingsBuilder builder, Boolean replicateAsync) {
        if (replicateAsync != null) {
            if (replicateAsync.booleanValue()) {
                builder.replicateAsynchronously();
            } else {
                CacheSettingsMapper.applyUsingReflection(builder, "replicateSynchronously");
            }
        }
    }

    private static void applyMaxEntries(CacheSettingsBuilder builder, Integer maxEntries) {
        if (maxEntries != null) {
            builder.maxEntries(maxEntries.intValue());
        }
    }

    private static void applyLocal(CacheSettingsBuilder builder, Boolean local) {
        if (local != null) {
            if (local.booleanValue()) {
                builder.local();
            } else {
                builder.remote();
            }
        }
    }

    private static void applyFlushable(CacheSettingsBuilder builder, Boolean flushable) {
        if (flushable != null) {
            if (flushable.booleanValue()) {
                builder.flushable();
            } else {
                builder.unflushable();
            }
        }
    }

    private static void applyExpireAfterWrite(CacheSettingsBuilder builder, Long expireAfterWrite) {
        if (expireAfterWrite != null) {
            builder.expireAfterWrite(expireAfterWrite.longValue(), TimeUnit.MILLISECONDS);
        }
    }

    private static void applyExpireAfterAccess(CacheSettingsBuilder builder, Long expireAfterAccess) {
        if (expireAfterAccess != null) {
            builder.expireAfterAccess(expireAfterAccess.longValue(), TimeUnit.MILLISECONDS);
        }
    }
}

