/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.util.thumbnail;

import com.atlassian.core.util.thumbnail.ThumbnailDimension;
import com.google.common.base.Optional;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public final class ThumbnailUtil {
    private static final List<String> THUMBNAIL_MIME_TYPES = Collections.unmodifiableList(Arrays.asList(ImageIO.getReaderMIMETypes()));
    private static final List<String> THUMBNAIL_FORMATS = Collections.unmodifiableList(Arrays.asList(ImageIO.getReaderFormatNames()));

    public static List<String> getThumbnailMimeTypes() {
        return THUMBNAIL_MIME_TYPES;
    }

    public static List<String> getThumbnailFormats() {
        return THUMBNAIL_FORMATS;
    }

    public static boolean isMimeTypeSupported(String mimeType) {
        if (mimeType != null && !mimeType.trim().equalsIgnoreCase("")) {
            for (String supportedFormat : THUMBNAIL_MIME_TYPES) {
                if (!mimeType.equalsIgnoreCase(supportedFormat)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFormatSupported(String formatName) {
        if (formatName != null && !formatName.trim().equalsIgnoreCase("")) {
            for (String supportedFormat : THUMBNAIL_FORMATS) {
                if (!formatName.equalsIgnoreCase(supportedFormat)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static ThumbnailDimension dimensionsForImage(@Nonnull InputStream inputStream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ThumbnailDimension determineScaledDimensions(int maxWidth, int maxHeight, @Nonnull Image image) {
        return ThumbnailUtil.determineScaledDimensions(maxWidth, maxHeight, image.getWidth(null), image.getHeight(null));
    }

    public static ThumbnailDimension determineScaledDimensions(int maxWidth, int maxHeight, int imageWidth, int imageHeight) {
        if (maxHeight > imageHeight && maxWidth > imageWidth) {
            return new ThumbnailDimension(imageWidth, imageHeight);
        }
        double thumbRatio = (double)maxWidth / (double)maxHeight;
        double imageRatio = (double)imageWidth / (double)imageHeight;
        if (thumbRatio < imageRatio) {
            return new ThumbnailDimension(maxWidth, (int)Math.max(1.0, (double)maxWidth / imageRatio));
        }
        return new ThumbnailDimension((int)Math.max(1.0, (double)maxHeight * imageRatio), maxHeight);
    }

    public static ImageInputStream getImageInputStream(@Nonnull InputStream inputStream) throws IOException {
        return ImageIO.createImageInputStream(inputStream);
    }

    public static Optional<ImageReader> getFirstImageReader(@Nonnull ImageInputStream imageInputStream) throws IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReaders(imageInputStream);
        return readers.hasNext() ? Optional.of((Object)readers.next()) : Optional.absent();
    }

    public static int computeSubsamplingRatio(ThumbnailDimension original, ThumbnailDimension scaled, int samplingFactor) {
        double widthRatio = (double)original.getWidth() / (double)scaled.getWidth();
        double heightRatio = (double)original.getHeight() / (double)scaled.getHeight();
        double maxRatio = Math.max(widthRatio, heightRatio);
        double ratio = maxRatio / (double)samplingFactor;
        return Math.max(1, (int)Math.floor(ratio));
    }
}

