/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.task.longrunning;

import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.ProgressMeter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLongRunningTask
implements LongRunningTask {
    public static final Logger log = LoggerFactory.getLogger(AbstractLongRunningTask.class);
    long startTime = System.currentTimeMillis();
    long stopTime = 0L;
    protected ProgressMeter progress = new ProgressMeter();

    protected AbstractLongRunningTask() {
        this.progress.setStatus("Initializing... ");
    }

    @Override
    public void run() {
        this.progress.setStatus("Starting... ");
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public String getNameKey() {
        return null;
    }

    @Override
    public int getPercentageComplete() {
        return this.progress.getPercentageComplete();
    }

    @Override
    public String getCurrentStatus() {
        return this.progress.getStatus();
    }

    @Override
    public long getElapsedTime() {
        return (this.stopTime == 0L ? System.currentTimeMillis() : this.stopTime) - this.startTime;
    }

    @Override
    public long getEstimatedTimeRemaining() {
        long elapsedTime = this.getElapsedTime();
        if (this.getPercentageComplete() == 0) {
            return 0L;
        }
        long totalTimeEstimate = 100L * elapsedTime / (long)this.getPercentageComplete();
        return totalTimeEstimate - elapsedTime;
    }

    @Override
    public boolean isComplete() {
        return this.getPercentageComplete() == 100;
    }

    @Override
    public String getPrettyElapsedTime() {
        return this.prettyTime(this.getElapsedTime());
    }

    protected abstract ResourceBundle getResourceBundle();

    private String prettyTime(long time) {
        if (time < 1000L) {
            return "Less than a second";
        }
        if (time / DateUtils.SECOND_MILLIS < 60L) {
            return time / DateUtils.SECOND_MILLIS + " seconds";
        }
        String minutesAndAbove = null;
        try {
            minutesAndAbove = DateUtils.getDurationPretty(time / DateUtils.SECOND_MILLIS, this.getResourceBundle());
        }
        catch (MissingResourceException e) {
            log.error("Could not load resourcebundle for 'minute'!'", (Throwable)e);
        }
        long secondsRemainder = time / DateUtils.SECOND_MILLIS % 60L;
        if (secondsRemainder > 0L) {
            minutesAndAbove = minutesAndAbove + ", " + secondsRemainder + " second" + (secondsRemainder == 1L ? "" : "s");
        }
        return minutesAndAbove;
    }

    @Override
    public String getPrettyTimeRemaining() {
        long estimatedTimeRemaining = this.getEstimatedTimeRemaining();
        if (estimatedTimeRemaining == 0L) {
            return "Unknown";
        }
        return this.prettyTime(estimatedTimeRemaining);
    }

    @Override
    public boolean isSuccessful() {
        return this.progress.isCompletedSuccessfully();
    }

    protected void stopTimer() {
        this.stopTime = System.currentTimeMillis();
    }
}

