/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.rest;

import com.atlassian.crowd.directory.authentication.AzureAdRefreshTokenFilter;
import com.atlassian.crowd.directory.authentication.MsGraphApiAuthenticator;
import com.atlassian.crowd.directory.authentication.impl.MsalAuthenticatorFactory;
import com.atlassian.crowd.directory.rest.AzureAdPagingWrapper;
import com.atlassian.crowd.directory.rest.AzureAdRestClient;
import com.atlassian.crowd.directory.rest.AzureAdRestClientFactory;
import com.atlassian.crowd.directory.rest.endpoint.AzureApiUriResolver;
import com.atlassian.crowd.directory.rest.util.IoUtilsWrapper;
import com.atlassian.crowd.directory.rest.util.JerseyLoggingFilter;
import com.fasterxml.jackson.core.util.JacksonFeature;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.primitives.Ints;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAzureAdRestClientFactory
implements AzureAdRestClientFactory {
    public static final String DISABLE_SSL_VALIDATION = "crowd.azure.test.disable.ssl.validation";
    private final MsalAuthenticatorFactory msalAuthenticatorFactory;
    private final IoUtilsWrapper ioUtilsWrapper;
    private static final Logger log = LoggerFactory.getLogger(DefaultAzureAdRestClientFactory.class);

    public DefaultAzureAdRestClientFactory(MsalAuthenticatorFactory msalAuthenticatorFactory, IoUtilsWrapper ioUtilsWrapper) {
        this.msalAuthenticatorFactory = msalAuthenticatorFactory;
        this.ioUtilsWrapper = ioUtilsWrapper;
    }

    @Override
    public AzureAdRestClient create(String clientId, String clientSecret, String tenantId, AzureApiUriResolver endpointDataProvider, long connectionTimeout, long readTimeout) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)tenantId), (Object)"Tenant ID not specified");
        Client jerseyClient = this.createJerseyClient(clientId, clientSecret, tenantId, endpointDataProvider, connectionTimeout, readTimeout);
        return new AzureAdRestClient(jerseyClient, endpointDataProvider, this.ioUtilsWrapper);
    }

    @VisibleForTesting
    Client createJerseyClient(String clientId, String clientSecret, String tenantId, AzureApiUriResolver azureApiUriResolver, long connectionTimeout, long readTimeout) {
        ClientConfig config = new ClientConfig();
        config.register(JacksonFeature.class);
        config.register(JerseyLoggingFilter.class);
        ClientBuilder clientBuilder = DefaultAzureAdRestClientFactory.configSslVerification(ClientBuilder.newBuilder());
        Client jerseyClient = clientBuilder.withConfig((Configuration)config).build();
        jerseyClient.property("jersey.config.client.connectTimeout", (Object)this.loggedSaturatedCast(connectionTimeout, "connection"));
        jerseyClient.property("jersey.config.client.readTimeout", (Object)this.loggedSaturatedCast(readTimeout, "read"));
        MsGraphApiAuthenticator msalAuthenticator = this.msalAuthenticatorFactory.create(clientId, clientSecret, tenantId, azureApiUriResolver);
        jerseyClient.register((Object)this.createAzureAdTokenFilter(msalAuthenticator));
        return jerseyClient;
    }

    private static ClientBuilder configSslVerification(ClientBuilder clientBuilder) {
        if (Boolean.getBoolean(DISABLE_SSL_VALIDATION)) {
            try {
                log.warn("Disabling SSL verification for Azure AD REST client");
                SSLContext sslcontext = SSLContext.getInstance("TLS");
                sslcontext.init(null, new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }}, new SecureRandom());
                return clientBuilder.sslContext(sslcontext).hostnameVerifier((s1, s2) -> true);
            }
            catch (Exception ignore) {
                log.warn("Failed to disable SSL verification for Azure AD REST client", (Throwable)ignore);
            }
        }
        return clientBuilder;
    }

    private int loggedSaturatedCast(long valueAsLong, String timeoutType) {
        int saturatedValueAsInt = Ints.saturatedCast((long)valueAsLong);
        if (valueAsLong != (long)saturatedValueAsInt) {
            log.debug("Specified value {} for {} timeout cannot be represented as an integer, performing saturated cast to {}", new Object[]{valueAsLong, timeoutType, saturatedValueAsInt});
        }
        return saturatedValueAsInt;
    }

    @Override
    public AzureAdPagingWrapper create(AzureAdRestClient restClient) {
        return new AzureAdPagingWrapper(restClient);
    }

    private AzureAdRefreshTokenFilter createAzureAdTokenFilter(final MsGraphApiAuthenticator msalAuthenticator) {
        return new AzureAdRefreshTokenFilter((LoadingCache<String, String>)CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String key) throws Exception {
                Preconditions.checkArgument((boolean)"AZURE_AD_TOKEN".equals(key));
                return msalAuthenticator.getApiToken().accessToken();
            }
        }));
    }
}

