/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.db.config.password.ciphers.algorithm;

import com.atlassian.db.config.password.ciphers.algorithm.AlgorithmCipher;
import com.atlassian.db.config.password.ciphers.algorithm.paramters.DecryptionParameters;
import com.atlassian.db.config.password.ciphers.algorithm.paramters.EncryptionParameters;
import com.atlassian.db.config.password.ciphers.algorithm.serialization.SerializationFileFactory;
import java.time.Clock;
import java.util.Objects;
import java.util.function.Function;
import javax.crypto.SealedObject;

public class AesOnlyAlgorithmCipher
extends AlgorithmCipher {
    public AesOnlyAlgorithmCipher() {
    }

    AesOnlyAlgorithmCipher(SerializationFileFactory factory, Clock clock, Function<String, String> getSystemEnv) {
        super(factory, clock, getSystemEnv);
    }

    @Override
    protected DecryptionParameters encrypt(EncryptionParameters parameters) {
        if (this.isAlgorithmRestricted(parameters.getAlgorithm())) {
            throw new IllegalArgumentException(String.format("Cannot encrypt with algorithm %s as it's not allowed", parameters.getAlgorithm()));
        }
        return super.encrypt(parameters);
    }

    @Override
    protected SealedObject getEncryptedPassword(DecryptionParameters dataToDecrypt) {
        SealedObject encryptedPassword = super.getEncryptedPassword(dataToDecrypt);
        if (this.isAlgorithmRestricted(encryptedPassword.getAlgorithm())) {
            throw new IllegalArgumentException(String.format("Cannot decrypt algorithm %s as it's not allowed", encryptedPassword.getAlgorithm()));
        }
        return encryptedPassword;
    }

    private boolean isAlgorithmRestricted(String algorithm) {
        String[] algorithmSplitIntoTransforms = algorithm.split("/");
        String algorithmToCompare = algorithmSplitIntoTransforms.length > 0 ? algorithmSplitIntoTransforms[0] : algorithm;
        return !Objects.equals(algorithmToCompare, "AES");
    }
}

