/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.extras.core.bamboo;

import com.atlassian.extras.api.LicenseEdition;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.bamboo.BambooLicense;
import com.atlassian.extras.common.LicenseTypeAndEditionResolver;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.core.DefaultProductLicense;
import com.atlassian.extras.core.bamboo.BambooLicenseAttributes;

class DefaultBambooLicense
extends DefaultProductLicense
implements BambooLicense {
    private final int maximumNumberOfRemoteAgents;
    private final int maximumNumberOfLocalAgents;
    private final int maximumNumberOfPlans;
    private final LicenseEdition licenseEdition;

    DefaultBambooLicense(Product product, LicenseProperties licenseProperties) {
        super(product, licenseProperties);
        this.licenseEdition = LicenseTypeAndEditionResolver.getLicenseEdition(licenseProperties.getProperty("LicenseEdition"));
        Integer value = BambooLicenseAttributes.extractValue(licenseProperties, "NumberOfBambooRemoteAgents");
        this.maximumNumberOfRemoteAgents = value == null ? BambooLicenseAttributes.calculateRemoteAgents(this.getLicenseType(), this.licenseEdition) : value;
        value = BambooLicenseAttributes.extractValue(licenseProperties, "NumberOfBambooLocalAgents");
        this.maximumNumberOfLocalAgents = value == null ? BambooLicenseAttributes.calculateLocalAgents(this.getLicenseType(), this.licenseEdition) : value;
        value = BambooLicenseAttributes.extractValue(licenseProperties, "NumberOfBambooPlans");
        this.maximumNumberOfPlans = value == null ? BambooLicenseAttributes.calculatePlans(this.getLicenseType()) : value;
    }

    @Override
    public LicenseEdition getLicenseEdition() {
        return this.licenseEdition;
    }

    @Override
    public int getMaximumNumberOfRemoteAgents() {
        return this.maximumNumberOfRemoteAgents;
    }

    @Override
    public int getMaximumNumberOfLocalAgents() {
        return this.maximumNumberOfLocalAgents;
    }

    @Override
    public int getMaximumNumberOfPlans() {
        return this.maximumNumberOfPlans;
    }

    @Override
    public boolean isUnlimitedRemoteAgents() {
        return -1 == this.maximumNumberOfRemoteAgents;
    }

    @Override
    public boolean isUnlimitedLocalAgents() {
        return -1 == this.maximumNumberOfLocalAgents;
    }

    @Override
    public boolean isUnlimitedPlans() {
        return -1 == this.maximumNumberOfPlans;
    }
}

