/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.integrationtesting.common;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;

public final class Functions {
    public static <A, B> Function0<B> partiallyApply(final Function<A, B> f, final A a) {
        return new Function0<B>(){

            @Override
            public B apply() {
                return f.apply(a);
            }
        };
    }

    public static <A> Function<Iterable<A>, Iterable<A>> sortedCopy(Ordering<A> order) {
        return new SortedCopy<A>(order);
    }

    public static <A> Function<A, A> identity(Class<A> c) {
        return Functions.identity();
    }

    public static <A> Function<A, A> identity() {
        return com.google.common.base.Functions.identity();
    }

    private static final class SortedCopy<A>
    implements Function<Iterable<A>, Iterable<A>> {
        private final Ordering<A> ordering;

        public SortedCopy(Ordering<A> ordering) {
            this.ordering = ordering;
        }

        public Iterable<A> apply(Iterable<A> xs) {
            return this.ordering.sortedCopy(xs);
        }
    }

    public static interface Function0<A> {
        public A apply();
    }
}

