/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.integrationtesting.runner.restore;

import com.atlassian.integrationtesting.runner.CompositeTestRunner;
import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.integrationtesting.ui.CompositeUiTester;
import com.atlassian.integrationtesting.ui.RestoreFromBackupException;
import com.atlassian.integrationtesting.ui.UiTester;
import com.google.common.base.Function;
import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;

public final class RestoreFromBackup {
    public static CompositeTestRunner.Composer compose(Injector injector) {
        return CompositeTestRunner.compose().beforeTestClass(new BeforeClass(injector)).beforeTestMethod(new BeforeMethod(injector)).afterTestMethod(new AfterMethod(injector));
    }

    private static void restore(String baseUrl, String filename, String username) {
        URL fileUrl = RestoreFromBackup.class.getClassLoader().getResource(filename);
        if (fileUrl == null) {
            throw new RestoreFromBackupException("Backup file " + filename + " not found");
        }
        RestoreFromBackup.restore(baseUrl, fileUrl, username);
    }

    private static void restore(String baseUrl, URL file, String username) {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(baseUrl + "/rest/ait/1.0/restore");
        try {
            post.addHeader(new BasicScheme().authenticate((Credentials)new UsernamePasswordCredentials(username, username), (HttpRequest)post));
        }
        catch (AuthenticationException e) {
            throw new RestoreFromBackupException("Unable to do restore", e);
        }
        try {
            post.setEntity((HttpEntity)new InputStreamEntity(file.openStream(), -1L));
        }
        catch (IOException e) {
            throw new RestoreFromBackupException("Unable to open restore file", e);
        }
        try {
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RestoreFromBackupException("Failure during restore - " + IOUtils.toString((InputStream)response.getEntity().getContent()));
            }
        }
        catch (ClientProtocolException e) {
            throw new RestoreFromBackupException("Unable to do restore", e);
        }
        catch (IOException e) {
            throw new RestoreFromBackupException("Unable to do restore", e);
        }
    }

    public static enum UsingRestResource implements Function<CompositeUiTester.Backup, Void>
    {
        INSTANCE;


        public Void apply(CompositeUiTester.Backup backup) {
            RestoreFromBackup.restore(backup.client.getBaseUrl(), backup.data, backup.username);
            return null;
        }
    }

    private static final class AfterMethod
    implements Function<CompositeTestRunner.AfterTestMethod, Void> {
        private final Injector injector;

        public AfterMethod(Injector injector) {
            this.injector = injector;
        }

        public Void apply(CompositeTestRunner.AfterTestMethod test) {
            if (test.hasAnnotation(Restore.class) && test.hasAnnotation(RestoreOnce.class)) {
                RestoreOnce restoreOnce = test.getAnnotation(RestoreOnce.class);
                ((UiTester)this.injector.getInstance(UiTester.class)).restore(restoreOnce.value(), restoreOnce.user());
            }
            return null;
        }
    }

    private static final class BeforeMethod
    implements Function<CompositeTestRunner.BeforeTestMethod, Void> {
        private final Injector injector;

        public BeforeMethod(Injector injector) {
            this.injector = injector;
        }

        public Void apply(CompositeTestRunner.BeforeTestMethod test) {
            if (test.hasAnnotation(Restore.class)) {
                Restore restore = test.getAnnotation(Restore.class);
                ((UiTester)this.injector.getInstance(UiTester.class)).restore(restore.value(), restore.user());
            }
            return null;
        }
    }

    private static final class BeforeClass
    implements Function<CompositeTestRunner.BeforeTestClass, Void> {
        private final Injector injector;

        public BeforeClass(Injector injector) {
            this.injector = injector;
        }

        public Void apply(CompositeTestRunner.BeforeTestClass test) {
            if (test.hasAnnotation(RestoreOnce.class)) {
                if (test.hasAnnotation(Restore.class)) {
                    throw new RuntimeException("Both @Restore and @RestoreOnce found on class. Only one should be present.");
                }
                RestoreOnce restoreOnce = test.getAnnotation(RestoreOnce.class);
                ((UiTester)this.injector.getInstance(UiTester.class)).restore(restoreOnce.value(), restoreOnce.user());
            }
            return null;
        }
    }
}

