/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.compatibility.factory.project.version;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.compatibility.bridge.impl.project.version.VersionManagerBridge63Impl;
import com.atlassian.jira.compatibility.bridge.impl.project.version.VersionManagerBridge70Impl;
import com.atlassian.jira.compatibility.bridge.project.version.VersionManagerBridge;
import com.atlassian.jira.compatibility.detection.MethodDetection;
import com.atlassian.jira.compatibility.factory.BridgeBeanFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.util.concurrent.LazyReference;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class VersionManagerBridgeFactory
extends BridgeBeanFactory<VersionManagerBridge> {
    @ClusterSafe(value="Local component reference")
    private final LazyReference<VersionManagerBridge> versionManagerBridge = new LazyReference<VersionManagerBridge>(){

        protected VersionManagerBridge create() throws Exception {
            VersionManager versionManager = ComponentAccessor.getVersionManager();
            if (VersionManagerBridgeFactory.is70VersionManager()) {
                return new VersionManagerBridge70Impl(versionManager);
            }
            return new VersionManagerBridge63Impl(versionManager);
        }
    };

    private static boolean is70VersionManager() {
        return MethodDetection.findMethod(VersionManager.class, Version.class, (String)"editVersionStartDate", (Class[])new Class[]{Version.class, Date.class}).isDefined();
    }

    public VersionManagerBridgeFactory() {
        super(VersionManagerBridge.class);
    }

    @Override
    public Object getObject() {
        return this.versionManagerBridge.get();
    }
}

