/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarsDisabledException;
import com.atlassian.jira.avatar.NoPermissionException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import java.net.URI;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public interface AvatarService {
    public Avatar getAvatar(ApplicationUser var1, String var2) throws AvatarsDisabledException;

    public Avatar getAvatar(ApplicationUser var1, ApplicationUser var2) throws AvatarsDisabledException;

    public URI getAvatarURL(ApplicationUser var1, String var2) throws AvatarsDisabledException;

    public URI getAvatarURL(@Nullable ApplicationUser var1, @Nullable ApplicationUser var2) throws AvatarsDisabledException;

    public URI getAvatarURL(ApplicationUser var1, String var2, Avatar.Size var3) throws AvatarsDisabledException;

    public URI getAvatarURL(ApplicationUser var1, ApplicationUser var2, Avatar.Size var3) throws AvatarsDisabledException;

    public Optional<URI> getGravatarAvatarURL(ApplicationUser var1, Avatar.Size var2);

    public URI getAvatarUrlNoPermCheck(String var1, Avatar.Size var2) throws AvatarsDisabledException;

    public URI getAvatarUrlNoPermCheck(ApplicationUser var1, Avatar.Size var2) throws AvatarsDisabledException;

    @Deprecated
    public URI getAvatarUrlNoPermCheck(ApplicationUser var1, Avatar var2, @Nonnull Avatar.Size var3) throws AvatarsDisabledException;

    public URI getAvatarAbsoluteURL(ApplicationUser var1, String var2, Avatar.Size var3) throws AvatarsDisabledException;

    public URI getAvatarAbsoluteURL(ApplicationUser var1, ApplicationUser var2, Avatar.Size var3) throws AvatarsDisabledException;

    public URI getProjectAvatarURL(Project var1, Avatar.Size var2);

    public URI getProjectAvatarAbsoluteURL(Project var1, Avatar.Size var2);

    public URI getProjectDefaultAvatarURL(Avatar.Size var1);

    public URI getProjectDefaultAvatarAbsoluteURL(Avatar.Size var1);

    @ExperimentalApi
    public boolean hasCustomUserAvatar(ApplicationUser var1, String var2);

    @ExperimentalApi
    public boolean hasCustomUserAvatar(ApplicationUser var1, ApplicationUser var2);

    @ExperimentalApi
    @Deprecated
    public boolean isGravatarEnabled();

    public boolean isUsingExternalAvatar(ApplicationUser var1, ApplicationUser var2);

    @ExperimentalApi
    public void setCustomUserAvatar(ApplicationUser var1, String var2, Long var3) throws AvatarsDisabledException, NoPermissionException;

    @ExperimentalApi
    public void setCustomUserAvatar(ApplicationUser var1, ApplicationUser var2, Long var3) throws AvatarsDisabledException, NoPermissionException;

    @ExperimentalApi
    public boolean canSetCustomUserAvatar(ApplicationUser var1, String var2);

    @ExperimentalApi
    public boolean canSetCustomUserAvatar(ApplicationUser var1, ApplicationUser var2);

    public Avatar getAvatarTagged(ApplicationUser var1, ApplicationUser var2) throws AvatarsDisabledException;
}

