/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import javax.annotation.concurrent.Immutable;

@ExperimentalApi
@Immutable
public class RemoteAvatar {
    private final String url16x16;
    private final String url24x24;
    private final String url32x32;
    private final String url48x48;

    public RemoteAvatar(String url16x16, String url24x24, String url32x32, String url48x48) {
        this.url16x16 = url16x16;
        this.url24x24 = url24x24;
        this.url32x32 = url32x32;
        this.url48x48 = url48x48;
    }

    @HtmlSafe
    public String getUrl16x16() {
        return this.url16x16;
    }

    @HtmlSafe
    public String getUrl24x24() {
        return this.url24x24;
    }

    @HtmlSafe
    public String getUrl32x32() {
        return this.url32x32;
    }

    @HtmlSafe
    public String getUrl48x48() {
        return this.url48x48;
    }

    public static RemoteAvatar from(JSONObject avatarUrls) throws JSONException {
        return new RemoteAvatar(avatarUrls.getString("16x16"), avatarUrls.getString("24x24"), avatarUrls.getString("32x32"), avatarUrls.getString("48x48"));
    }

    public static RemoteAvatar from(Project project) {
        Long avatarId = project.getAvatar().getId();
        if (avatarId == null) {
            return null;
        }
        String baseUrl = ComponentAccessor.getComponent(JiraBaseUrls.class).baseUrl() + "/secure/projectavatar?avatarId=" + avatarId;
        return new RemoteAvatar(baseUrl + "&size=xsmall", baseUrl + "&size=small", baseUrl + "&size=medium", baseUrl);
    }

    public static RemoteAvatar from(ApplicationUser user) {
        String baseUrl = ComponentAccessor.getComponent(JiraBaseUrls.class).baseUrl() + "/secure/useravatar?ownerId=" + user.getKey();
        return new RemoteAvatar(baseUrl + "&size=xsmall", baseUrl + "&size=small", baseUrl + "&size=medium", baseUrl);
    }
}

