/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.config.properties.PropertiesAccessor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
class JiraSystemPropertiesCache
implements PropertiesAccessor {
    private static final Object NULL_VALUE = new Object();
    private static Function<Callable<Object>, Object> HANDLING_EXCEPTIONS = new Function<Callable<Object>, Object>(){

        public Object apply(Callable<Object> input) {
            try {
                return input.call();
            }
            catch (SecurityException se) {
                JiraSystemPropertiesCache.getLogger().warn("Security exception occurred while accessing system properties.", (Throwable)se);
                return null;
            }
            catch (NullPointerException e) {
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };
    private final PropertiesAccessor propertiesAccessor;
    private final LoadingCache<CacheKey, Object> cache;
    public static final long CACHE_WRITE_EXPIRY_SECONDS = 60L;
    public static final int CACHE_CAPACITY = 100;

    private static Logger getLogger() {
        return LoggerFactory.getLogger(JiraSystemPropertiesCache.class);
    }

    public JiraSystemPropertiesCache(PropertiesAccessor accessor) {
        this.propertiesAccessor = accessor;
        this.cache = this.newBuilder().build(CacheLoader.from((Function)new Function<CacheKey, Object>(){
            private final Map<Class<?>, Function<String, Object>> classBasedHandlers = ImmutableMap.builder().put(Properties.class, (Object)new Function<String, Object>(){

                public Object apply(String input) {
                    return JiraSystemPropertiesCache.this.propertiesAccessor.getProperties();
                }
            }).put(String.class, (Object)new Function<String, Object>(){

                public Object apply(String input) {
                    return JiraSystemPropertiesCache.this.propertiesAccessor.getProperty(input);
                }
            }).put(Integer.class, (Object)new Function<String, Object>(){

                public Object apply(String input) {
                    return JiraSystemPropertiesCache.this.propertiesAccessor.getInteger(input);
                }
            }).put(Long.class, (Object)new Function<String, Object>(){

                public Object apply(String input) {
                    return JiraSystemPropertiesCache.this.propertiesAccessor.getLong(input);
                }
            }).put(Boolean.class, (Object)new Function<String, Object>(){

                public Object apply(String input) {
                    return JiraSystemPropertiesCache.this.propertiesAccessor.getBoolean(input);
                }
            }).build();

            public Object apply(CacheKey input) {
                Function<String, Object> propertyAccessFunction = this.classBasedHandlers.get(input.ofClass);
                Preconditions.checkNotNull(propertyAccessFunction);
                Object result = propertyAccessFunction.apply((Object)input.key);
                return result == null ? NULL_VALUE : result;
            }
        }));
    }

    @VisibleForTesting
    protected CacheBuilder<Object, Object> newBuilder() {
        return CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).maximumSize(100L).concurrencyLevel(6);
    }

    @Override
    public String getProperty(@Nonnull String key) {
        return (String)this.getCached(CacheKey.build(key, String.class));
    }

    @Override
    public void setProperty(final @Nonnull String key, final @Nonnull String value) {
        HANDLING_EXCEPTIONS.apply((Object)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JiraSystemPropertiesCache.this.propertiesAccessor.setProperty(key, value);
                return null;
            }
        });
        this.invalidate(key);
    }

    @Override
    public Boolean getBoolean(@Nonnull String key) {
        return (Boolean)this.getCached(CacheKey.build(key, Boolean.class));
    }

    @Override
    public Integer getInteger(@Nonnull String key) {
        return (Integer)this.getCached(CacheKey.build(key, Integer.class));
    }

    @Override
    public Long getLong(@Nonnull String key) {
        return (Long)this.getCached(CacheKey.build(key, Long.class));
    }

    @Override
    public void refresh() {
        this.clear();
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        Properties systemProps = (Properties)HANDLING_EXCEPTIONS.apply((Object)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return JiraSystemPropertiesCache.this.cache.getUnchecked((Object)CacheKey.PROPERTIES_CACHE_KEY);
            }
        });
        props.putAll((Map<?, ?>)systemProps);
        return props;
    }

    @Override
    public void setProperties(final @Nonnull Properties props) {
        HANDLING_EXCEPTIONS.apply((Object)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JiraSystemPropertiesCache.this.propertiesAccessor.setProperties(props);
                return null;
            }
        });
        this.invalidate();
    }

    public void clear() {
        this.invalidate();
    }

    @Override
    public void refresh(@Nonnull String key) {
        Preconditions.checkNotNull((Object)key);
        this.invalidate(key);
    }

    @Override
    public void unsetProperty(final @Nonnull String key) {
        HANDLING_EXCEPTIONS.apply((Object)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JiraSystemPropertiesCache.this.propertiesAccessor.unsetProperty(key);
                return null;
            }
        });
        this.invalidate(key);
    }

    private Object getCached(final CacheKey cacheKey) {
        try {
            Object result = HANDLING_EXCEPTIONS.apply((Object)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return JiraSystemPropertiesCache.this.cache.getUnchecked((Object)cacheKey);
                }
            });
            if (result == NULL_VALUE) {
                this.cache.invalidate((Object)cacheKey);
                return null;
            }
            return result;
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    private void invalidate(@Nonnull String key) {
        for (Class<?> ofClass : CacheKey.handledClasses) {
            this.cache.invalidate((Object)CacheKey.build(key, ofClass));
        }
    }

    private void invalidate() {
        this.cache.invalidateAll();
    }

    static class CacheKey {
        static final CacheKey PROPERTIES_CACHE_KEY = new CacheKey("", Properties.class);
        static final Set<Class<?>> handledClasses = ImmutableSet.of(String.class, Integer.class, Long.class, Boolean.class, Properties.class);
        final Class<?> ofClass;
        final String key;

        @VisibleForTesting
        static CacheKey build(String key, Class<?> ofClass) {
            assert (handledClasses.contains(ofClass)) : "Keys must be constructed for allowed classes only. Got " + (ofClass == null ? ofClass : ofClass.getName());
            if (Properties.class.equals(ofClass)) {
                return PROPERTIES_CACHE_KEY;
            }
            Preconditions.checkNotNull((Object)key);
            return new CacheKey(key, ofClass);
        }

        private CacheKey(String key, Class<?> ofClass) {
            this.key = key;
            this.ofClass = ofClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            return this.key.equals(other.key) && this.ofClass.equals(other.ofClass);
        }

        public int hashCode() {
            return 31 * this.ofClass.hashCode() + (this.key != null ? this.key.hashCode() : 0);
        }
    }
}

