/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.WorklogBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.VisibilityJsonBean;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.JiraDurationUtils;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonRootName(value="worklog")
public class WorklogJsonBean {
    @JsonProperty
    private URI self;
    @JsonProperty
    private UserJsonBean author;
    @JsonProperty
    private UserJsonBean updateAuthor;
    @JsonProperty
    private String comment;
    @JsonProperty
    private String created;
    @JsonProperty
    private String updated;
    @JsonProperty
    private VisibilityJsonBean visibility;
    @JsonIgnore
    private boolean isVisibilitySet;
    @JsonProperty
    private String started;
    @JsonProperty
    private String timeSpent;
    @JsonProperty
    private Long timeSpentSeconds;
    @JsonProperty
    private String id;
    @JsonProperty
    private String issueId;
    public static final WorklogJsonBean UPDATE_DOC_EXAMPLE = WorklogJsonBean.build().setComment("I did some work here.").setVisibility(new VisibilityJsonBean(VisibilityJsonBean.VisibilityType.group, "jira-developers")).setStarted(Dates.asTimeString(new Date())).setTimeSpentSeconds(12000L).build();
    public static final WorklogJsonBean DOC_EXAMPLE = WorklogJsonBean.build().setSelf(URI.create("http://www.example.com/jira/rest/api/2/issue/10010/worklog/10000")).setAuthor(UserJsonBean.USER_SHORT_DOC_EXAMPLE).setUpdateAuthor(UserJsonBean.USER_SHORT_DOC_EXAMPLE).setComment("I did some work here.").setVisibility(new VisibilityJsonBean(VisibilityJsonBean.VisibilityType.group, "jira-developers")).setStarted(Dates.asTimeString(new Date())).setUpdated(Dates.asTimeString(new Date())).setTimeSpent("3h 20m").setTimeSpentSeconds(12000L).setId("100028").setIssueId("10002").build();

    public WorklogJsonBean() {
    }

    private WorklogJsonBean(URI self, UserJsonBean author, UserJsonBean updateAuthor, String comment, String created, String updated, VisibilityJsonBean visibility, boolean isVisibilitySet, String started, String timeSpent, Long timeSpentSeconds, String id, String issueId) {
        this.self = self;
        this.author = author;
        this.updateAuthor = updateAuthor;
        this.comment = comment;
        this.created = created;
        this.updated = updated;
        this.visibility = visibility;
        this.isVisibilitySet = isVisibilitySet;
        this.started = started;
        this.timeSpent = timeSpent;
        this.timeSpentSeconds = timeSpentSeconds;
        this.id = id;
        this.issueId = issueId;
    }

    public static Builder build() {
        return new Builder();
    }

    @Deprecated
    public static List<WorklogJsonBean> asBeans(List<Worklog> worklogs, JiraBaseUrls uriInfo, UserManager userManager, TimeTrackingConfiguration timeTrackingConfiguration) {
        ApplicationUser loggedInUser = ComponentAccessor.getComponent(JiraAuthenticationContext.class).getLoggedInUser();
        return ImmutableList.copyOf(ComponentAccessor.getComponent(WorklogBeanFactory.class).createBeans(worklogs, loggedInUser));
    }

    @Deprecated
    public static List<WorklogJsonBean> asBeans(List<Worklog> worklogs, JiraBaseUrls uriInfo, UserManager userManager, TimeTrackingConfiguration timeTrackingConfiguration, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        return ImmutableList.copyOf(ComponentAccessor.getComponent(WorklogBeanFactory.class).createBeans(worklogs, loggedInUser));
    }

    @Deprecated
    public static WorklogJsonBean getWorklog(Worklog log, JiraBaseUrls baseUrls, UserManager userManager, TimeTrackingConfiguration timeTrackingConfiguration) {
        ApplicationUser loggedInUser = ComponentAccessor.getComponent(JiraAuthenticationContext.class).getLoggedInUser();
        return ComponentAccessor.getComponent(WorklogBeanFactory.class).createBean(log, loggedInUser);
    }

    @Deprecated
    public static WorklogJsonBean getWorklog(Worklog log, JiraBaseUrls baseUrls, UserManager userManager, TimeTrackingConfiguration timeTrackingConfiguration, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        return ComponentAccessor.getComponent(WorklogBeanFactory.class).createBean(log, loggedInUser);
    }

    private static void addNonRenderableData(WorklogJsonBean bean, Worklog log, JiraBaseUrls baseUrls, UserManager userManager, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        try {
            bean.self = new URI(baseUrls.restApi2BaseUrl() + "issue/" + log.getIssue().getId().toString() + "/worklog/" + log.getId().toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to generate worklog self url", e);
        }
        bean.author = WorklogJsonBean.getUserBean(baseUrls, log.getAuthor(), userManager, loggedInUser, emailFormatter);
        bean.updateAuthor = WorklogJsonBean.getUserBean(baseUrls, log.getUpdateAuthor(), userManager, loggedInUser, emailFormatter);
        bean.id = Long.toString(log.getId());
        bean.issueId = Long.toString(log.getIssue().getId());
        String groupLevel = log.getGroupLevel();
        ProjectRole roleLevel = log.getRoleLevel();
        if (groupLevel != null) {
            bean.visibility = new VisibilityJsonBean(VisibilityJsonBean.VisibilityType.group, groupLevel);
        } else if (roleLevel != null) {
            bean.visibility = new VisibilityJsonBean(VisibilityJsonBean.VisibilityType.role, roleLevel.getName());
        }
    }

    @Deprecated
    public static List<WorklogJsonBean> asRenderedBeans(List<Worklog> worklogs, JiraBaseUrls uriInfo, String rendererType, IssueRenderContext renderContext) {
        return WorklogJsonBean.asRenderedBeans(worklogs, uriInfo, rendererType, renderContext, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public static List<WorklogJsonBean> asRenderedBeans(List<Worklog> worklogs, JiraBaseUrls uriInfo, String rendererType, IssueRenderContext renderContext, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        ArrayList result = Lists.newArrayListWithCapacity((int)worklogs.size());
        for (Worklog worklog : worklogs) {
            result.add(WorklogJsonBean.getRenderedWorklog(worklog, uriInfo, rendererType, renderContext, loggedInUser, emailFormatter));
        }
        return result;
    }

    @Deprecated
    public static WorklogJsonBean getRenderedWorklog(Worklog log, JiraBaseUrls baseUrls, String rendererType, IssueRenderContext renderContext) {
        return WorklogJsonBean.getRenderedWorklog(log, baseUrls, rendererType, renderContext, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public static WorklogJsonBean getRenderedWorklog(Worklog log, JiraBaseUrls baseUrls, String rendererType, IssueRenderContext renderContext, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        WorklogJsonBean bean = new WorklogJsonBean();
        WorklogJsonBean.addNonRenderableData(bean, log, baseUrls, ComponentAccessor.getUserManager(), loggedInUser, emailFormatter);
        if (StringUtils.isNotBlank((CharSequence)rendererType)) {
            RendererManager rendererManager = ComponentAccessor.getComponent(RendererManager.class);
            bean.comment = rendererManager.getRenderedContent(rendererType, log.getComment(), renderContext);
        } else {
            bean.comment = log.getComment();
        }
        JiraDurationUtils jiraDurationUtils = ComponentAccessor.getComponent(JiraDurationUtils.class);
        bean.timeSpent = jiraDurationUtils.getFormattedDuration(log.getTimeSpent(), ComponentAccessor.getJiraAuthenticationContext().getLocale());
        DateTimeFormatterFactory dateTimeFormatterFactory = ComponentAccessor.getComponent(DateTimeFormatterFactory.class);
        bean.created = log.getCreated() == null ? "" : dateTimeFormatterFactory.formatter().forLoggedInUser().format(log.getCreated());
        bean.updated = log.getUpdated() == null ? "" : dateTimeFormatterFactory.formatter().forLoggedInUser().format(log.getUpdated());
        bean.started = log.getStartDate() == null ? "" : dateTimeFormatterFactory.formatter().forLoggedInUser().format(log.getStartDate());
        return bean;
    }

    protected static UserJsonBean getUserBean(JiraBaseUrls uriInfo, String username, UserManager userManager, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        ApplicationUser user = userManager.getUserByName(username);
        if (user != null) {
            return ComponentAccessor.getComponent(UserBeanFactory.class).createBean(user, loggedInUser, uriInfo, emailFormatter, ComponentAccessor.getComponent(TimeZoneManager.class));
        }
        if (StringUtils.isNotBlank((CharSequence)username)) {
            UserJsonBean userJsonBean = new UserJsonBean();
            userJsonBean.setName(username);
            return userJsonBean;
        }
        return null;
    }

    public UserJsonBean getAuthor() {
        return this.author;
    }

    public UserJsonBean getUpdateAuthor() {
        return this.updateAuthor;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getCreated() {
        return Dates.fromTimeString(this.created);
    }

    @JsonGetter(value="created")
    public String getCreatedString() {
        return this.created;
    }

    public Date getUpdated() {
        return Dates.fromTimeString(this.updated);
    }

    @JsonGetter(value="updated")
    public String getUpdatedString() {
        return this.updated;
    }

    public Date getStarted() {
        return Dates.fromTimeString(this.started);
    }

    @JsonGetter(value="started")
    public String getStartedtring() {
        return this.started;
    }

    public String getTimeSpent() {
        return this.timeSpent;
    }

    public Long getTimeSpentSeconds() {
        return this.timeSpentSeconds;
    }

    @JsonProperty
    public VisibilityJsonBean getVisibility() {
        return this.visibility;
    }

    @JsonProperty
    public void setVisibility(VisibilityJsonBean visibility) {
        this.isVisibilitySet = true;
        this.visibility = visibility;
    }

    @JsonIgnore
    public boolean isVisibilitySet() {
        return this.isVisibilitySet;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIssueId() {
        return this.issueId;
    }

    public void setIssueId(String issueId) {
        this.issueId = issueId;
    }

    public URI getSelf() {
        return this.self;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("self", (Object)this.self).append("author", (Object)this.author).append("updateAuthor", (Object)this.updateAuthor).append("comment", (Object)this.comment).append("created", (Object)this.created).append("updated", (Object)this.updated).append("visibility", (Object)this.visibility).append("isVisibilitySet", this.isVisibilitySet).append("started", (Object)this.started).append("timeSpent", (Object)this.timeSpent).append("timeSpentSeconds", (Object)this.timeSpentSeconds).append("id", (Object)this.id).append("issueId", (Object)this.issueId).toString();
    }

    public static class Builder {
        private URI self;
        private UserJsonBean author;
        private UserJsonBean updateAuthor;
        private String comment;
        private String created;
        private String updated;
        private VisibilityJsonBean visibility;
        private boolean isVisibilitySet;
        private String started;
        private String timeSpent;
        private Long timeSpentSeconds;
        private String id;
        private String issueId;

        public Builder setSelf(URI self) {
            this.self = self;
            return this;
        }

        public Builder setAuthor(UserJsonBean author) {
            this.author = author;
            return this;
        }

        public Builder setUpdateAuthor(UserJsonBean updateAuthor) {
            this.updateAuthor = updateAuthor;
            return this;
        }

        public Builder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder setCreated(String created) {
            this.created = created;
            return this;
        }

        public Builder setUpdated(String updated) {
            this.updated = updated;
            return this;
        }

        public Builder setVisibility(VisibilityJsonBean visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder setIsVisibilitySet(boolean isVisibilitySet) {
            this.isVisibilitySet = isVisibilitySet;
            return this;
        }

        public Builder setStarted(String started) {
            this.started = started;
            return this;
        }

        public Builder setTimeSpent(String timeSpent) {
            this.timeSpent = timeSpent;
            return this;
        }

        public Builder setTimeSpentSeconds(Long timeSpentSeconds) {
            this.timeSpentSeconds = timeSpentSeconds;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setIssueId(String issueId) {
            this.issueId = issueId;
            return this;
        }

        public WorklogJsonBean build() {
            return new WorklogJsonBean(this.self, this.author, this.updateAuthor, this.comment, this.created, this.updated, this.visibility, this.isVisibilitySet, this.started, this.timeSpent, this.timeSpentSeconds, this.id, this.issueId);
        }
    }
}

