/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleWarningCollection;
import com.atlassian.jira.util.WarningCollection;
import com.atlassian.jira.util.dbc.Assertions;

@PublicApi
public class ServiceResultImpl
implements ServiceResult {
    private final ErrorCollection errorCollection;
    private final WarningCollection warningCollection;

    public ServiceResultImpl(ErrorCollection errorCollection) {
        this(errorCollection, new SimpleWarningCollection());
    }

    public ServiceResultImpl(ErrorCollection errorCollection, WarningCollection warningCollection) {
        Assertions.notNull("errorCollection", errorCollection);
        Assertions.notNull("errorCollection", warningCollection);
        this.errorCollection = errorCollection;
        this.warningCollection = warningCollection;
    }

    @Override
    public boolean isValid() {
        return !this.errorCollection.hasAnyErrors();
    }

    @Override
    public ErrorCollection getErrorCollection() {
        return this.errorCollection;
    }

    @Override
    public WarningCollection getWarningCollection() {
        return this.warningCollection;
    }
}

