/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.jira.issue.comparator.LocaleSensitiveVersionNameComparator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class VersionClauseValuesGenerator
implements ClauseValuesGenerator {
    private final VersionManager versionManager;
    private final PermissionManager permissionManager;
    private final I18nHelper.BeanFactory beanFactory;

    public VersionClauseValuesGenerator(VersionManager versionManager, PermissionManager permissionManager, I18nHelper.BeanFactory beanFactory) {
        this.versionManager = versionManager;
        this.permissionManager = permissionManager;
        this.beanFactory = beanFactory;
    }

    @Override
    public ClauseValuesGenerator.Results getPossibleValues(ApplicationUser searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        ArrayList<Version> versions = new ArrayList<Version>(this.versionManager.getAllVersions());
        Collections.sort(versions, new LocaleSensitiveVersionNameComparator(this.getLocale(searcher)));
        LinkedHashSet<ClauseValuesGenerator.Result> versionValues = new LinkedHashSet<ClauseValuesGenerator.Result>();
        for (Version version : versions) {
            Project project;
            if (versionValues.size() == maxNumResults) break;
            String lowerCaseVersionName = version.getName().toLowerCase();
            if (!StringUtils.isBlank((String)valuePrefix) && !lowerCaseVersionName.startsWith(valuePrefix.toLowerCase()) || (project = version.getProjectObject()) == null || !this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, searcher)) continue;
            versionValues.add(new ClauseValuesGenerator.Result(version.getName()));
        }
        return new ClauseValuesGenerator.Results(new ArrayList<ClauseValuesGenerator.Result>(versionValues));
    }

    Locale getLocale(ApplicationUser searcher) {
        return this.beanFactory.getInstance(searcher).getLocale();
    }
}

