/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;

@Internal
public class IsAdminCondition
implements Condition {
    private final JiraAuthenticationContext authenticationContext;
    private final GlobalPermissionManager permissionManager;

    public IsAdminCondition(JiraAuthenticationContext authenticationContext, GlobalPermissionManager permissionManager) {
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        return user != null && this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }
}

