/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.mail;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityExprList;
import org.ofbiz.core.entity.EntityOperator;

@ParametersAreNonnullByDefault
@Internal
class DeadLetterStore {
    private static final int DEFAULT_DEADLETTER_EXPIRATION_DAYS = 30;
    private static final Duration DEFAULT_DEADLETTER_EXPIRATION = Duration.ofDays(30L);
    private static final String ENTITY = "DeadLetter";
    private static final String MESSAGE_ID = "messageId";
    private static final String LAST_SEEN = "lastSeen";
    private static final String MAILSERVER_ID = "mailServerId";
    private static final String FOLDER_NAME = "folderName";
    private static final AtomicBoolean logWarningOnlyOnce = new AtomicBoolean(false);
    private final Clock clock;
    private final Logger log;
    private final DeadLetterDao deadLetterDao;
    private final Duration expirationDuration;

    @VisibleForTesting
    DeadLetterStore(OfBizDelegator ofBizDelegator, Clock clock, ApplicationProperties applicationProperties, Logger log) {
        this.deadLetterDao = new DeadLetterDao(ofBizDelegator);
        this.clock = clock;
        this.log = log;
        this.expirationDuration = this.getDeadLetterExpirationDuration(applicationProperties);
    }

    DeadLetterStore(Logger log) {
        this.clock = Clock.systemDefaultZone();
        this.log = (Logger)Preconditions.checkNotNull((Object)log);
        this.deadLetterDao = new DeadLetterDao(ComponentAccessor.getOfBizDelegator());
        this.expirationDuration = this.getDeadLetterExpirationDuration(ComponentAccessor.getApplicationProperties());
    }

    public boolean exists(@Nullable String messageId, Long mailServerId, String folderName) {
        if (messageId == null || this.isDisabled()) {
            return false;
        }
        Preconditions.checkNotNull((Object)mailServerId);
        Preconditions.checkNotNull((Object)folderName);
        return this.deadLetterDao.exists(messageId, mailServerId, folderName);
    }

    void createOrUpdate(@Nullable String messageId, Long mailServerId, String folderName) {
        if (messageId == null || this.isDisabled()) {
            return;
        }
        Preconditions.checkNotNull((Object)mailServerId);
        Preconditions.checkNotNull((Object)folderName);
        if (this.deadLetterDao.createOrUpdate(messageId, mailServerId, this.clock.instant().toEpochMilli(), folderName)) {
            this.logDebug("Adding to dead letter store. Will delete it the next run, message: %s", messageId);
        } else {
            this.logDebug("Message already added to dead letter store, updating its lastSeen time. Will delete it the next run, message: %s", messageId);
        }
    }

    public void delete(@Nullable String messageId, Long mailServerId, String folderName) {
        if (messageId == null || this.isDisabled()) {
            return;
        }
        Preconditions.checkNotNull((Object)mailServerId);
        Preconditions.checkNotNull((Object)folderName);
        if (this.deadLetterDao.delete(messageId, mailServerId, folderName)) {
            this.logDebug("Removed from dead letter store, message: %s", messageId);
        }
    }

    void deleteOldDeadLetters() {
        if (this.isDisabled()) {
            return;
        }
        int removedDeadLetters = this.deadLetterDao.deleteOlderThan(this.clock.instant().minus(this.expirationDuration).toEpochMilli());
        this.logDebug("Removed %d expired dead letters from store", removedDeadLetters);
    }

    private boolean isDisabled() {
        return this.expirationDuration.isNegative();
    }

    private Duration getDeadLetterExpirationDuration(ApplicationProperties applicationProperties) {
        String expireTimeString = applicationProperties.getDefaultBackedString("jira.email.deadletters.expiration.time.days");
        if (StringUtils.isEmpty((CharSequence)expireTimeString)) {
            this.logDebug("Property '%s' is not set. Using default value of %d days.", "jira.email.deadletters.expiration.time.days", 30);
            return DEFAULT_DEADLETTER_EXPIRATION;
        }
        try {
            return Duration.ofDays(Integer.parseInt(expireTimeString));
        }
        catch (NumberFormatException e) {
            if (logWarningOnlyOnce.compareAndSet(false, true)) {
                this.log.warn((Object)String.format("Invalid format of '%s' property = '%s'. Expected value to be an int. Using default value of %d days instead.", "jira.email.deadletters.expiration.time.days", expireTimeString, 30));
            }
            return DEFAULT_DEADLETTER_EXPIRATION;
        }
    }

    private void logDebug(String msg, Object ... params) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format(msg, params));
        }
    }

    private static class DeadLetterDao {
        private final OfBizDelegator ofBizDelegator;

        DeadLetterDao(OfBizDelegator ofBizDelegator) {
            this.ofBizDelegator = ofBizDelegator;
        }

        boolean createOrUpdate(String messageId, Long mailServerId, long timestamp, String folderName) {
            if (this.exists(messageId, mailServerId, folderName)) {
                this.ofBizDelegator.bulkUpdateByAnd(DeadLetterStore.ENTITY, (Map<String, ?>)ImmutableMap.of((Object)DeadLetterStore.LAST_SEEN, (Object)timestamp), (Map<String, ?>)ImmutableMap.of((Object)DeadLetterStore.MESSAGE_ID, (Object)messageId, (Object)DeadLetterStore.MAILSERVER_ID, (Object)mailServerId, (Object)DeadLetterStore.FOLDER_NAME, (Object)folderName));
                return false;
            }
            this.ofBizDelegator.createValue(DeadLetterStore.ENTITY, (Map<String, Object>)ImmutableMap.of((Object)DeadLetterStore.MESSAGE_ID, (Object)messageId, (Object)DeadLetterStore.MAILSERVER_ID, (Object)mailServerId, (Object)DeadLetterStore.LAST_SEEN, (Object)timestamp, (Object)DeadLetterStore.FOLDER_NAME, (Object)folderName));
            return true;
        }

        boolean exists(String messageId, Long mailServerId, String folderName) {
            return this.ofBizDelegator.findByCondition(DeadLetterStore.ENTITY, (EntityCondition)this.messageIdMailServerAndFolderCondition(messageId, mailServerId, folderName), null, null).size() > 0;
        }

        boolean delete(String messageId, Long mailServerId, String folderName) {
            return this.ofBizDelegator.removeByCondition(DeadLetterStore.ENTITY, (EntityCondition)this.messageIdMailServerAndFolderCondition(messageId, mailServerId, folderName)) > 0;
        }

        private EntityExprList messageIdMailServerAndFolderCondition(String messageId, Long mailServerId, String folderName) {
            EntityExpr messageIdCondition = new EntityExpr(DeadLetterStore.MESSAGE_ID, EntityOperator.EQUALS, (Object)messageId);
            EntityExpr mailServerIdCondition = new EntityExpr(DeadLetterStore.MAILSERVER_ID, EntityOperator.EQUALS, (Object)mailServerId);
            EntityExpr folderNameCondition = new EntityExpr(DeadLetterStore.FOLDER_NAME, EntityOperator.EQUALS, (Object)folderName);
            return new EntityExprList((List)ImmutableList.of((Object)messageIdCondition, (Object)mailServerIdCondition, (Object)folderNameCondition), EntityOperator.AND);
        }

        int deleteOlderThan(long timestamp) {
            return this.ofBizDelegator.removeByCondition(DeadLetterStore.ENTITY, (EntityCondition)new EntityExpr(DeadLetterStore.LAST_SEEN, EntityOperator.LESS_THAN, (Object)timestamp));
        }
    }
}

