/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.event.AbstractEvent;
import com.atlassian.jira.event.issue.IssueEventVisitor;
import com.atlassian.jira.event.issue.IssueRelatedEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.JiraStringUtils;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.ofbiz.core.entity.GenericValue;

@PublicApi
public final class IssueEvent
extends AbstractEvent
implements IssueRelatedEvent {
    public static final String SEND_MAIL = "sendMail";
    public static final String BASE_URL_PARAM_NAME = JiraStringUtils.asString(new Object[]{"baseurl"});
    public static final String CUSTOM_FIELDS_PARAM_NAME = JiraStringUtils.asString(new Object[]{"com.atlassian.jira.event.issue.CUSTOM_FIELDS"});
    public static final String WATCHERS_PARAM_NAME = JiraStringUtils.asString(new Object[]{"com.atlassian.jira.event.issue.WATCHERS"});
    public static final String CHANGE_HISTORY_PARAM_NAME = JiraStringUtils.asString(new Object[]{"com.atlassian.jira.event.issue.CHANGE_HISTORY"});
    public static final String COMMENTS_PARAM_NAME = JiraStringUtils.asString(new Object[]{"com.atlassian.jira.event.issue.COMMENTS"});
    private Issue issue;
    private ApplicationUser user;
    private Worklog worklog;
    private GenericValue changeGroup;
    private Comment comment;
    private Long eventTypeId;
    private boolean subtasksUpdated;
    private boolean sendMail = true;
    private boolean redundant = false;

    public IssueEvent(Issue issue, Map params, ApplicationUser user, Long eventTypeId) {
        this(issue, user, null, null, null, params, eventTypeId, true, false);
    }

    public IssueEvent(Issue issue, Map params, ApplicationUser user, Long eventTypeId, boolean sendMail) {
        this(issue, user, null, null, null, params, eventTypeId, sendMail, false);
    }

    public IssueEvent(Issue issue, ApplicationUser user, Comment comment, Worklog worklog, GenericValue changeGroup, Map params, Long eventTypeId) {
        this(issue, user, comment, worklog, changeGroup, params, eventTypeId, true, false);
    }

    public IssueEvent(Issue issue, ApplicationUser user, Comment comment, Worklog worklog, GenericValue changeGroup, Map params, Long eventTypeId, boolean sendMail) {
        this(issue, user, comment, worklog, changeGroup, params, eventTypeId, sendMail, false);
    }

    public IssueEvent(Issue issue, ApplicationUser user, Comment comment, Worklog worklog, GenericValue changeGroup, Map params, Long eventTypeId, boolean sendMail, boolean subtasksUpdated) {
        super(params);
        this.issue = issue;
        this.user = user;
        this.eventTypeId = eventTypeId;
        this.sendMail = sendMail;
        this.worklog = worklog;
        this.changeGroup = changeGroup;
        this.comment = comment;
        this.subtasksUpdated = subtasksUpdated;
    }

    @Override
    public Issue getIssue() {
        return this.issue;
    }

    public Project getProject() {
        return this.issue.getProjectObject();
    }

    public ApplicationUser getUser() {
        return this.user;
    }

    public GenericValue getChangeLog() {
        return this.changeGroup;
    }

    public Comment getComment() {
        return this.comment;
    }

    public Worklog getWorklog() {
        return this.worklog;
    }

    public void setWorklog(Worklog worklog) {
        this.worklog = worklog;
    }

    public Long getEventTypeId() {
        return this.eventTypeId;
    }

    public boolean isSendMail() {
        return this.sendMail;
    }

    public boolean isSubtasksUpdated() {
        return this.subtasksUpdated;
    }

    @Internal
    void makeRedundant() {
        this.redundant = true;
    }

    @Internal
    public boolean isRedundant() {
        return this.redundant;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("issue", (Object)this.getIssue()).append("comment", (Object)this.getComment()).append("worklog", (Object)this.getWorklog()).append("changelog", (Object)this.getChangeLog()).append("eventTypeId", (Object)this.getEventTypeId()).append(SEND_MAIL, (Object)(this.isSendMail() ? "true" : "false")).append("params", this.getParams()).append("subtasksUpdated", this.isSubtasksUpdated()).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IssueEvent)) {
            return false;
        }
        IssueEvent event = (IssueEvent)o;
        if (this.getParams() != null ? !this.getParams().equals(event.getParams()) : event.getParams() != null) {
            return false;
        }
        if (this.changeGroup != null ? !this.changeGroup.equals((Object)event.changeGroup) : event.changeGroup != null) {
            return false;
        }
        if (this.comment != null ? !this.comment.equals(event.comment) : event.comment != null) {
            return false;
        }
        if (this.worklog != null ? !this.worklog.equals(event.worklog) : event.worklog != null) {
            return false;
        }
        if (this.issue != null ? !this.issue.equals(event.issue) : event.issue != null) {
            return false;
        }
        if (this.eventTypeId != null ? !this.eventTypeId.equals(event.eventTypeId) : event.eventTypeId != null) {
            return false;
        }
        if (this.sendMail != event.isSendMail()) {
            return false;
        }
        return this.subtasksUpdated == event.isSubtasksUpdated();
    }

    public <T> T accept(IssueEventVisitor<T> visitor) {
        if (this.eventTypeId.equals(EventType.ISSUE_CREATED_ID)) {
            return visitor.onIssueCreated(this);
        }
        if (this.eventTypeId.equals(EventType.ISSUE_UPDATED_ID)) {
            return visitor.onIssueUpdated(this);
        }
        if (this.eventTypeId.equals(EventType.ISSUE_ASSIGNED_ID)) {
            return visitor.onIssueAssigned(this);
        }
        if (this.eventTypeId.equals(EventType.ISSUE_RESOLVED_ID)) {
            return visitor.onIssueResolved(this);
        }
        if (this.eventTypeId.equals(EventType.ISSUE_COMMENTED_ID)) {
            return visitor.onIssueCommented(this);
        }
        if (this.eventTypeId.equals(EventType.ISSUE_COMMENT_EDITED_ID)) {
            return visitor.onIssueCommentEdited(this);
        }
        if (this.eventTypeId.equals(EventType.ISSUE_COMMENT_DELETED_ID)) {
            return visitor.onIssueCommentDeleted(this);
        }
        if (this.eventTypeId.equals(EventType.ISSUE_CLOSED_ID)) {
            return visitor.onIssueClosed(this);
        }
        if (this.eventTypeId.equals(EventType.ISSUE_REOPENED_ID)) {
            return visitor.onIssueReopened(this);
        }
        if (this.eventTypeId.equals(EventType.ISSUE_DELETED_ID)) {
            return visitor.onIssueDeleted(this);
        }
        if (this.eventTypeId.equals(EventType.ISSUE_MOVED_ID)) {
            return visitor.onIssueMoved(this);
        }
        if (this.eventTypeId.equals(EventType.ISSUE_WORKLOGGED_ID)) {
            return visitor.onIssueWorkLogged(this);
        }
        if (this.eventTypeId.equals(EventType.ISSUE_WORKSTARTED_ID)) {
            return visitor.onIssueWorkStarted(this);
        }
        if (this.eventTypeId.equals(EventType.ISSUE_WORKSTOPPED_ID)) {
            return visitor.onIssueWorkStopped(this);
        }
        if (this.eventTypeId.equals(EventType.ISSUE_WORKLOG_UPDATED_ID)) {
            return visitor.onIssueWorklogUpdated(this);
        }
        if (this.eventTypeId.equals(EventType.ISSUE_WORKLOG_DELETED_ID)) {
            return visitor.onIssueWorklogDeleted(this);
        }
        if (this.eventTypeId.equals(EventType.ISSUE_GENERICEVENT_ID)) {
            return visitor.onIssueGenericEvent(this);
        }
        return visitor.onCustomEvent(this);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.issue != null ? this.issue.hashCode() : 0);
        result = 29 * result + (this.changeGroup != null ? this.changeGroup.hashCode() : 0);
        result = 29 * result + (this.comment != null ? this.comment.hashCode() : 0);
        result = 29 * result + (this.worklog != null ? this.worklog.hashCode() : 0);
        result = 29 * result + (this.eventTypeId != null ? this.eventTypeId.hashCode() : 0);
        result = 29 * result + (this.sendMail ? 1 : 0);
        result = 29 * result + (this.subtasksUpdated ? 1 : 0);
        return result;
    }
}

