/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.fugue.Option;
import com.atlassian.jira.license.LicenseDetails;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public final class LicenseChangedEvent {
    public final Option<? extends LicenseDetails> previousLicenseDetails;
    public final Option<? extends LicenseDetails> newLicenseDetails;

    public LicenseChangedEvent(@Nonnull Option<? extends LicenseDetails> previousLicenseDetails, @Nonnull Option<? extends LicenseDetails> newLicenseDetails) {
        this.previousLicenseDetails = (Option)Preconditions.checkNotNull(previousLicenseDetails, (Object)"previousLicenseDetails");
        this.newLicenseDetails = (Option)Preconditions.checkNotNull(newLicenseDetails, (Object)"newLicenseDetails");
    }

    public final Option<? extends LicenseDetails> getNewLicenseDetails() {
        return this.newLicenseDetails;
    }

    public final Option<? extends LicenseDetails> getPreviousLicenseDetails() {
        return this.previousLicenseDetails;
    }

    public boolean isNewLicense() {
        return !this.previousLicenseDetails.isDefined() && this.newLicenseDetails.isDefined();
    }

    public boolean isLicenseUpdated() {
        return this.previousLicenseDetails.isDefined() && this.newLicenseDetails.isDefined();
    }

    public boolean isLicenseRemoved() {
        return this.previousLicenseDetails.isDefined() && !this.newLicenseDetails.isDefined();
    }

    private static String toShortLicenseString(Option<? extends LicenseDetails> details) {
        return (String)details.map(LicenseDetails::getLicenseString).map(str -> StringUtils.abbreviate((String)str, (int)100)).getOrNull();
    }

    public String toString() {
        return String.format("LicenseChangedEvent(old: %s, new: %s)", LicenseChangedEvent.toShortLicenseString(this.previousLicenseDetails), LicenseChangedEvent.toShortLicenseString(this.newLicenseDetails));
    }
}

