/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import org.apache.commons.collections.Predicate;

public class ObjectUtils {
    private static final Long UNSELECTED_LONG = new Long(-1L);

    private ObjectUtils() {
    }

    public static boolean isNotEmpty(Object o) {
        return o != null && !"".equals(o);
    }

    public static Predicate getIsSetPredicate() {
        return new Predicate(){

            public boolean evaluate(Object o) {
                return ObjectUtils.isNotEmpty(o);
            }
        };
    }

    public static boolean isValueSelected(Object selectValue) {
        return selectValue != null && !"".equals(selectValue) && !"-1".equals(selectValue) && !UNSELECTED_LONG.equals(selectValue);
    }

    public static boolean equalsNullSafe(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static <T> T firstIfNotNull(T first, T second) {
        return first != null ? first : second;
    }
}

