/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.issue.index.indexers.impl.FieldIndexerUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public class ExactTextCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private final CustomField field;

    public ExactTextCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, Assertions.notNull("field", customField));
        this.field = customField;
    }

    @Override
    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, true);
    }

    @Override
    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, false);
    }

    private void addDocumentFields(Document doc, Issue issue, boolean searchable) {
        Object value = this.field.getValue(issue);
        String stringValue = this.field.getCustomFieldType().getStringFromSingularObject(value);
        if (value != null) {
            if (searchable) {
                doc.add((IndexableField)new StringField(this.getDocumentFieldId(), stringValue, Field.Store.YES));
                doc.add((IndexableField)new SortedDocValuesField(this.getDocumentFieldId(), new BytesRef((CharSequence)stringValue)));
            } else {
                doc.add((IndexableField)new StoredField(this.getDocumentFieldId(), stringValue));
            }
        }
        String string = FieldIndexerUtil.getValueForSorting((String)value);
        doc.add((IndexableField)new SortedDocValuesField("sort_" + this.getDocumentFieldId(), new BytesRef((CharSequence)string)));
    }
}

