/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dashboard;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.bc.dashboard.DashboardItem;
import com.atlassian.jira.bc.dashboard.DashboardItemLocator;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@PublicApi
final class DashboardItemImpl
implements DashboardItem {
    private final DashboardItemLocator locator;

    public DashboardItemImpl(@Nonnull DashboardItemLocator locator) {
        this.locator = (DashboardItemLocator)Preconditions.checkNotNull((Object)locator);
    }

    @Override
    public DashboardItemLocator getLocator() {
        return this.locator;
    }

    @Override
    public Long getId() {
        return this.gadgetIdAsLong(this.locator);
    }

    private Long gadgetIdAsLong(DashboardItemLocator locator) {
        return Long.valueOf(locator.getGadgetId().value());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardItemImpl that = (DashboardItemImpl)o;
        return this.locator.equals(that.locator);
    }

    public int hashCode() {
        return this.locator.hashCode();
    }

    public String toString() {
        return "DashboardItem (" + this.locator + ")";
    }
}

