/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@PublicApi
public interface IssueTypeSchemeService {
    public ServiceOutcome<FieldConfigScheme> createIssueTypeScheme(ApplicationUser var1, String var2, String var3, List<String> var4, String var5);

    default public ServiceOutcome<FieldConfigScheme> createIssueTypeScheme(ApplicationUser user, String name, String description, List<String> issueTypeIds) {
        return this.createIssueTypeScheme(user, name, description, issueTypeIds, null);
    }

    public ServiceOutcome<List<FieldConfigScheme>> getAllIssueTypeSchemes(ApplicationUser var1);

    public ServiceOutcome<FieldConfigScheme> getIssueTypeScheme(ApplicationUser var1, long var2);

    default public ServiceOutcome<FieldConfigScheme> getIssueTypeScheme(ApplicationUser user, String schemeId) {
        if (StringUtils.isNumeric((CharSequence)schemeId)) {
            return this.getIssueTypeScheme(user, Long.parseLong(schemeId));
        }
        return this.errorCase("not a valid scheme id: " + schemeId, ErrorCollection.Reason.VALIDATION_FAILED);
    }

    public ServiceOutcome<FieldConfigScheme> updateIssueTypeScheme(ApplicationUser var1, long var2, String var4, String var5, List<String> var6, String var7);

    default public ServiceOutcome<FieldConfigScheme> updateIssueTypeScheme(ApplicationUser user, String schemeId, String name, String description, List<String> issueTypeIds, String defaultIssueTypeId) {
        if (StringUtils.isNumeric((CharSequence)schemeId)) {
            return this.updateIssueTypeScheme(user, Long.parseLong(schemeId), name, description, issueTypeIds, defaultIssueTypeId);
        }
        return this.errorCase("not a valid scheme id: " + schemeId, ErrorCollection.Reason.VALIDATION_FAILED);
    }

    default public ServiceOutcome<FieldConfigScheme> updateIssueTypeScheme(ApplicationUser user, long schemeId, String name, String description, List<String> issueTypeIds) {
        return this.updateIssueTypeScheme(user, schemeId, name, description, issueTypeIds, null);
    }

    default public ServiceOutcome<FieldConfigScheme> updateIssueTypeScheme(ApplicationUser user, String schemeId, String name, String description, List<String> issueTypeIds) {
        return this.updateIssueTypeScheme(user, schemeId, name, description, issueTypeIds, null);
    }

    public ServiceOutcome<Void> deleteIssueTypeScheme(ApplicationUser var1, long var2);

    default public ServiceOutcome<Void> deleteIssueTypeScheme(ApplicationUser user, String schemeId) {
        if (StringUtils.isNumeric((CharSequence)schemeId)) {
            return this.deleteIssueTypeScheme(user, Long.parseLong(schemeId));
        }
        return this.errorCase("not a valid scheme id: " + schemeId, ErrorCollection.Reason.VALIDATION_FAILED);
    }

    public ServiceOutcome<Void> addProjectAssociations(ApplicationUser var1, long var2, List<String> var4);

    default public ServiceOutcome<Void> addProjectAssociations(ApplicationUser user, String schemeId, List<String> projectIdsOrKeys) {
        if (StringUtils.isNumeric((CharSequence)schemeId)) {
            return this.addProjectAssociations(user, Long.parseLong(schemeId), projectIdsOrKeys);
        }
        return this.errorCase("not a valid scheme id: " + schemeId, ErrorCollection.Reason.VALIDATION_FAILED);
    }

    public ServiceOutcome<List<Project>> getAssociatedProjects(ApplicationUser var1, long var2);

    default public ServiceOutcome<List<Project>> getAssociatedProjects(ApplicationUser user, String schemeId) {
        if (StringUtils.isNumeric((CharSequence)schemeId)) {
            return this.getAssociatedProjects(user, Long.parseLong(schemeId));
        }
        return this.errorCase("not a valid scheme id: " + schemeId, ErrorCollection.Reason.VALIDATION_FAILED);
    }

    @Deprecated
    public ServiceOutcome<Void> setProjectAssociations(ApplicationUser var1, long var2, List<String> var4);

    default public ServiceOutcome<Void> setProjectAssociations(ApplicationUser user, String schemeId, List<String> projectIdsOrKeys) {
        if (StringUtils.isNumeric((CharSequence)schemeId)) {
            return this.setProjectAssociations(user, Long.parseLong(schemeId), projectIdsOrKeys);
        }
        return this.errorCase("not a valid scheme id " + schemeId, ErrorCollection.Reason.VALIDATION_FAILED);
    }

    public ServiceOutcome<Void> removeAllProjectAssociations(ApplicationUser var1, long var2);

    default public ServiceOutcome<Void> removeAllProjectAssociations(ApplicationUser user, String schemeId) {
        if (StringUtils.isNumeric((CharSequence)schemeId)) {
            return this.removeAllProjectAssociations(user, Long.parseLong(schemeId));
        }
        return this.errorCase("not a valid scheme id: " + schemeId, ErrorCollection.Reason.VALIDATION_FAILED);
    }

    public ServiceOutcome<Void> removeProjectAssociation(ApplicationUser var1, long var2, String var4);

    default public ServiceOutcome<Void> removeProjectAssociation(ApplicationUser user, String schemeId, String projKeyOrId) {
        if (StringUtils.isNumeric((CharSequence)schemeId)) {
            return this.removeProjectAssociation(user, Long.parseLong(schemeId), projKeyOrId);
        }
        return this.errorCase("not a valid scheme id: " + schemeId, ErrorCollection.Reason.VALIDATION_FAILED);
    }

    public ServiceOutcome<List<Issue>> getIssuesRequiringMigration(ApplicationUser var1, Collection<String> var2, List<Long> var3);

    public ServiceOutcome<List<Issue>> getIssuesRequiringMigrationDueToSchemeAssociation(ApplicationUser var1, FieldConfigScheme var2, List<Long> var3);

    public long getNumIssuesMatchingTypesInProjects(ApplicationUser var1, Collection<Long> var2, Collection<String> var3) throws SearchException;

    public List<Issue> getIssuesMatchingTypesInProjects(ApplicationUser var1, Collection<Long> var2, Collection<String> var3) throws SearchException;

    public <T> ServiceOutcome<T> errorCase(String var1, ErrorCollection.Reason var2);

    public IssueType getDefaultIssueType(FieldConfigScheme var1);
}

