/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.sharedentity;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ExperimentalApi
public class AbstractSharedEntityEvent {
    private SharedEntity entityFrom;
    private SharedEntity entityTo;

    AbstractSharedEntityEvent(@Nullable SharedEntity entityFrom, @Nullable SharedEntity entityTo) {
        Assertions.is("At least one of the Events must not be null!", entityFrom != null || entityTo != null);
        this.entityFrom = entityFrom;
        this.entityTo = entityTo;
    }

    @Nullable
    public SharedEntity getEntityFrom() {
        return this.entityFrom;
    }

    @Nullable
    public SharedEntity getEntityTo() {
        return this.entityTo;
    }

    @Nonnull
    public SharedEntity getChangedEntity() {
        return this.entityFrom == null ? this.entityTo : this.entityFrom;
    }
}

