/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.archiving;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import javax.annotation.Nonnull;

@ExperimentalApi
public interface ArchivedIssueService {
    public ArchivingResult archiveIssue(ValidationResult var1);

    public ArchivingResult restoreIssue(ValidationResult var1);

    public ValidationResult validateArchiveIssue(ApplicationUser var1, String var2, boolean var3);

    public ValidationResult validateRestoreIssue(ApplicationUser var1, String var2, boolean var3);

    public static class ValidationResult
    extends ServiceResultImpl {
        private final String issueKey;
        private final Issue issue;
        private final ApplicationUser user;
        private final boolean notifyUsers;

        public ValidationResult(ErrorCollection errorCollection, String issueKey) {
            super(errorCollection);
            this.issueKey = issueKey;
            this.issue = null;
            this.user = null;
            this.notifyUsers = true;
        }

        public ValidationResult(ErrorCollection errorCollection, @Nonnull Issue issue) {
            this(errorCollection, issue, null, true);
        }

        @Deprecated
        public ValidationResult(ErrorCollection errorCollection, @Nonnull Issue issue, ApplicationUser user) {
            this(errorCollection, issue, user, true);
        }

        public ValidationResult(ErrorCollection errorCollection, @Nonnull Issue issue, ApplicationUser user, boolean notifyUsers) {
            super(errorCollection);
            this.issueKey = issue.getKey();
            this.issue = issue;
            this.user = user;
            this.notifyUsers = notifyUsers;
        }

        public String getIssueKey() {
            return this.issueKey;
        }

        public Issue getIssue() {
            return this.issue;
        }

        public ApplicationUser getUser() {
            return this.user;
        }

        public boolean isNotifyUsers() {
            return this.notifyUsers;
        }
    }

    public static class ArchivingResult
    extends ValidationResult {
        public ArchivingResult(ErrorCollection errorCollection, @Nonnull Issue issue) {
            super(errorCollection, issue);
        }
    }
}

