/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.util.dbc.Assertions;

@PublicApi
public final class Label {
    private final Long id;
    private final Long issue;
    private final Long customFieldId;
    private final String label;

    public Label(Long id, Long issue, String label) {
        this(id, issue, null, label);
    }

    public Label(Long id, Long issue, Long customFieldId, String label) {
        this.id = id;
        this.issue = issue;
        this.label = Assertions.notNull("label", label);
        this.customFieldId = customFieldId;
    }

    public Long getCustomFieldId() {
        return this.customFieldId;
    }

    public Long getId() {
        return this.id;
    }

    public Long getIssue() {
        return this.issue;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Label label1 = (Label)o;
        if (this.customFieldId != null ? !this.customFieldId.equals(label1.customFieldId) : label1.customFieldId != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(label1.id) : label1.id != null) {
            return false;
        }
        if (this.issue != null ? !this.issue.equals(label1.issue) : label1.issue != null) {
            return false;
        }
        return this.label.equals(label1.label);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.issue != null ? this.issue.hashCode() : 0);
        result = 31 * result + (this.customFieldId != null ? this.customFieldId.hashCode() : 0);
        result = 31 * result + this.label.hashCode();
        return result;
    }

    public String toString() {
        return this.label;
    }
}

