/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail.settings;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.mail.OutgoingEmailConfigurationChangedEvent;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MailSetting {
    private static final Logger log = LoggerFactory.getLogger(MailSetting.class);
    private final ApplicationProperties applicationProperties;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final String name;
    private final Optional<EventPublisher> eventPublisher;

    @Deprecated
    public MailSetting(@Nonnull ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext, @Nonnull String name) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)jiraAuthenticationContext);
        this.eventPublisher = Optional.empty();
    }

    private MailSetting(@Nonnull ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext, @Nonnull String name, EventPublisher eventPublisher) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)jiraAuthenticationContext);
        this.eventPublisher = Optional.ofNullable(eventPublisher);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean getValue() {
        return this.applicationProperties.getOption(this.name);
    }

    @Nullable
    public String getModifiedBy() {
        return this.applicationProperties.getString(this.modifiedBy());
    }

    @Nullable
    public Date getModifiedDate() {
        String modDateVal = this.applicationProperties.getString(this.modifiedDate());
        Date modDate = null;
        if (StringUtils.isNotBlank((CharSequence)modDateVal)) {
            modDate = new Date(Long.parseLong(modDateVal));
        }
        return modDate;
    }

    public void setValue(boolean value) {
        this.applicationProperties.setOption(this.name, value);
        this.eventPublisher.ifPresent(publisher -> publisher.publish((Object)new OutgoingEmailConfigurationChangedEvent(value)));
        log.info("Mail setting '{}' has been set to '{}'", (Object)this.name, (Object)value);
        if (log.isDebugEnabled()) {
            log.trace("Dumping stack trace for mail setting change", new Throwable());
        }
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        this.applicationProperties.setString(this.modifiedBy(), user != null ? user.getKey() : "");
        this.applicationProperties.setString(this.modifiedDate(), String.valueOf(System.currentTimeMillis()));
    }

    private String modifiedDate() {
        return String.format("mailsetting.%s.modifiedDate", this.name);
    }

    private String modifiedBy() {
        return String.format("mailsetting.%s.modifiedBy", this.name);
    }

    public static final class Builder {
        private final ApplicationProperties applicationProperties;
        private final String name;
        private JiraAuthenticationContext jiraAuthenticationContext;
        private EventPublisher eventPublisher;

        public Builder(@Nonnull ApplicationProperties applicationProperties, @Nonnull String name) {
            this.applicationProperties = applicationProperties;
            this.name = name;
        }

        Builder withJiraAuthenticationContext(JiraAuthenticationContext jiraAuthenticationContext) {
            this.jiraAuthenticationContext = jiraAuthenticationContext;
            return this;
        }

        Builder withEventPublisher(EventPublisher eventPublisher) {
            this.eventPublisher = eventPublisher;
            return this;
        }

        MailSetting build() {
            return new MailSetting(this.applicationProperties, this.jiraAuthenticationContext, this.name, this.eventPublisher);
        }
    }
}

