/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mention;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@PublicApi
public interface MentionService {
    @Deprecated
    public void sendCommentMentions(@Nullable ApplicationUser var1, @Nullable Set<NotificationRecipient> var2, @Nullable Comment var3, @Nullable Comment var4);

    @Nonnull
    public MentionResult sendCommentMentions(@Nullable Set<NotificationRecipient> var1, @Nullable ApplicationUser var2, @Nullable Comment var3, @Nullable Comment var4);

    @Deprecated
    public void sendIssueCreateMentions(@Nullable ApplicationUser var1, @Nullable Set<NotificationRecipient> var2, @Nonnull Issue var3);

    @Nonnull
    public MentionResult sendIssueCreateMentions(@Nullable Set<NotificationRecipient> var1, @Nullable ApplicationUser var2, @Nonnull Issue var3);

    @Deprecated
    public void sendIssueEditMentions(@Nullable ApplicationUser var1, @Nullable Set<NotificationRecipient> var2, @Nonnull Issue var3, @Nullable Comment var4);

    @Nonnull
    public MentionResult sendIssueEditMentions(@Nullable Set<NotificationRecipient> var1, @Nullable ApplicationUser var2, @Nonnull Issue var3, @Nullable Comment var4);

    public boolean isUserAbleToMention(@Nullable ApplicationUser var1);

    @Nonnull
    public Mentions getMentionedUsers(@Nonnull IssueEvent var1);

    public static class MentionResult {
        public static final MentionResult EMPTY = new MentionResult(Collections.emptySet());
        private final Set<NotificationRecipient> notificationRecipients;

        public MentionResult(@Nonnull Set<NotificationRecipient> notificationRecipients) {
            this.notificationRecipients = Objects.requireNonNull(notificationRecipients);
        }

        @Nonnull
        public Set<NotificationRecipient> getNotificationRecipients() {
            return this.notificationRecipients;
        }
    }

    @Immutable
    public static class Mentions {
        private final Set<ApplicationUser> issueDescriptionMentions;
        private final Set<ApplicationUser> issueCommentMentions;

        public Mentions(@Nonnull Set<ApplicationUser> issueDescriptionMentions, @Nonnull Set<ApplicationUser> issueCommentMentions) {
            this.issueDescriptionMentions = Collections.unmodifiableSet(issueDescriptionMentions);
            this.issueCommentMentions = Collections.unmodifiableSet(issueCommentMentions);
        }

        @Nonnull
        public Set<ApplicationUser> getIssueDescriptionMentions() {
            return this.issueDescriptionMentions;
        }

        @Nonnull
        public Set<ApplicationUser> getIssueCommentMentions() {
            return this.issueCommentMentions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Mentions mentions = (Mentions)o;
            return Objects.equals(this.issueDescriptionMentions, mentions.issueDescriptionMentions) && Objects.equals(this.issueCommentMentions, mentions.issueCommentMentions);
        }

        public int hashCode() {
            return Objects.hash(this.issueDescriptionMentions, this.issueCommentMentions);
        }
    }
}

