/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Resolver;
import com.atlassian.jira.util.collect.Sized;
import java.util.ArrayList;
import java.util.List;

@PublicApi
public interface EnclosedIterable<T>
extends Sized {
    public void foreach(Consumer<T> var1);

    @Override
    public int size();

    @Override
    public boolean isEmpty();

    public static class Functions {
        public static <T> void apply(EnclosedIterable<T> iterable, Consumer<T> sink) {
            iterable.foreach(sink);
        }

        public static <T> List<T> toList(EnclosedIterable<T> iterable) {
            return Functions.toList(iterable, new Function<T, T>(){

                @Override
                public T apply(T input) {
                    return input;
                }
            });
        }

        public static <I, O> List<O> toList(EnclosedIterable<I> iterable, Function<I, O> transformer) {
            ArrayList result = new ArrayList(iterable.size());
            iterable.foreach(element -> result.add(transformer.apply((Object)element)));
            return result;
        }
    }

    public static class ListResolver<T>
    implements Resolver<EnclosedIterable<T>, List<T>> {
        @Override
        public List<T> apply(EnclosedIterable<T> iterable) {
            ArrayList result = new ArrayList();
            iterable.foreach(result::add);
            return result;
        }
    }
}

