/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatUtils;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.event.mau.MauApplicationKey;
import com.atlassian.jira.event.mau.MauEventService;
import com.atlassian.jira.hints.Hint;
import com.atlassian.jira.hints.HintManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.UriValidator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.web.HttpServletVariables;
import com.atlassian.jira.web.action.RedirectSanitiser;
import com.atlassian.jira.web.action.RequestSourceType;
import com.atlassian.jira.web.util.AuthorizationSupport;
import com.atlassian.jira.web.util.CookieUtils;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;
import webwork.action.ActionSupport;
import webwork.action.CommandDriven;
import webwork.action.CoreActionContext;
import webwork.action.ServletActionContext;
import webwork.dispatcher.ActionResult;
import webwork.util.ValueStack;
import webwork.util.editor.PropertyEditorException;

@NotThreadSafe
@PublicSpi
public class JiraWebActionSupport
extends ActionSupport
implements CommandDriven,
I18nHelper,
ErrorCollection,
AuthorizationSupport,
HttpServletVariables {
    protected final Logger log = Logger.getLogger(this.getClass());
    public static final String RETURN_URL_PARAMETER = "returnUrl";
    public static final String PERMISSION_VIOLATION_RESULT = "permissionviolation";
    public static final String SECURITY_BREACH_RESULT = "securitybreach";
    public static final String ISSUE_NOT_FOUND_RESULT = "issuenotfound";
    private static final String X_ATLASSIAN_DIALOG_CONTROL = "X-Atlassian-Dialog-Control";
    private static final String X_ATLASSIAN_DIALOG_MSG_HTML = "X-Atlassian-Dialog-Msg-Html";
    private static final String X_ATLASSIAN_DIALOG_MSG_CLOSEABLE = "X-Atlassian-Dialog-Msg-Closeable";
    private static final String X_ATLASSIAN_DIALOG_MSG_TYPE = "X-Atlassian-Dialog-Msg-Type";
    private static final String X_ATLASSIAN_DIALOG_MSG_TARGET = "X-Atlassian-Dialog-Msg-Target";
    private static final Pattern SELECTED_ISSUE_PATTERN = Pattern.compile("(&|&amp;)?selectedIssueId=[0-9]*");
    protected HttpServletRequest request = ServletActionContext.getRequest();
    private OutlookDate outlookDate;
    private String returnUrl;
    protected Collection savedFilters;
    private Project selectedProject;
    private boolean inline = false;
    private Preferences userPrefs;
    private I18nHelper i18nHelperDelegate;
    private OfBizDelegator ofBizDelegator;
    private PermissionManager permissionManager;
    private AuthorizationSupport authorizationSupport;
    private GlobalPermissionManager globalPermissionManager;
    private ProjectManager projectManager;
    private VersionManager versionManager;
    private UserProjectHistoryManager userProjectHistoryManager;
    private HintManager hintManager;
    private FieldManager fieldManager;
    private SearchSortUtil searchSortUtil;
    private JiraLicenseService jiraLicenseService;
    private volatile ApplicationProperties applicationProperties;
    private ConstantsManager constantsManager;
    private XsrfTokenGenerator xsrfTokenGenerator;
    private OutlookDateManager outlookDateManager;
    private volatile UriValidator uriValidator;
    private Set<ErrorCollection.Reason> reasons = new HashSet<ErrorCollection.Reason>();
    private DateTimeFormatter dateTimeFormatter;
    private DateTimeFormatter dmyDateFormatter;
    private JiraContactHelper jiraContactHelper;
    private UserManager userManager;
    private RedirectSanitiser safeRedirectProvider;
    private ComponentReference<MauEventService> mauEventService = ComponentAccessor.getComponentReference(MauEventService.class);

    public ApplicationUser getLoggedInUser() {
        return ComponentAccessor.getJiraAuthenticationContext().getUser();
    }

    @Deprecated
    public ApplicationUser getLoggedInApplicationUser() {
        return ComponentAccessor.getJiraAuthenticationContext().getUser();
    }

    public String getXsrfToken() {
        return this.getXsrfTokenGenerator().generateToken(ActionContext.getRequest());
    }

    private XsrfTokenGenerator getXsrfTokenGenerator() {
        if (this.xsrfTokenGenerator == null) {
            this.xsrfTokenGenerator = this.getComponentInstanceOfType(XsrfTokenGenerator.class);
        }
        return this.xsrfTokenGenerator;
    }

    private HttpServletVariables httpVariables() {
        return ComponentAccessor.getComponent(HttpServletVariables.class);
    }

    @Override
    public HttpServletRequest getHttpRequest() {
        return this.httpVariables().getHttpRequest();
    }

    @Override
    public HttpSession getHttpSession() {
        return this.httpVariables().getHttpSession();
    }

    @Override
    public HttpServletResponse getHttpResponse() {
        return this.httpVariables().getHttpResponse();
    }

    @Override
    public ServletContext getServletContext() {
        return this.httpVariables().getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationProperties getApplicationProperties() {
        if (this.applicationProperties == null) {
            JiraWebActionSupport jiraWebActionSupport = this;
            synchronized (jiraWebActionSupport) {
                if (this.applicationProperties == null) {
                    this.applicationProperties = this.getComponentInstanceOfType(ApplicationProperties.class);
                }
            }
        }
        return this.applicationProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UriValidator getUriValidator() {
        if (this.uriValidator == null) {
            JiraWebActionSupport jiraWebActionSupport = this;
            synchronized (jiraWebActionSupport) {
                if (this.uriValidator == null) {
                    this.uriValidator = new UriValidator(this.getApplicationProperties().getEncoding());
                }
            }
        }
        return this.uriValidator;
    }

    protected GlobalPermissionManager getGlobalPermissionManager() {
        if (this.globalPermissionManager == null) {
            this.globalPermissionManager = this.getComponentInstanceOfType(GlobalPermissionManager.class);
        }
        return this.globalPermissionManager;
    }

    protected PermissionManager getPermissionManager() {
        if (this.permissionManager == null) {
            this.permissionManager = this.getComponentInstanceOfType(PermissionManager.class);
        }
        return this.permissionManager;
    }

    protected UserProjectHistoryManager getUserProjectHistoryManager() {
        if (this.userProjectHistoryManager == null) {
            this.userProjectHistoryManager = this.getComponentInstanceOfType(UserProjectHistoryManager.class);
        }
        return this.userProjectHistoryManager;
    }

    public ConstantsManager getConstantsManager() {
        if (this.constantsManager == null) {
            this.constantsManager = this.getComponentInstanceOfType(ConstantsManager.class);
        }
        return this.constantsManager;
    }

    public ProjectManager getProjectManager() {
        if (this.projectManager == null) {
            this.projectManager = this.getComponentInstanceOfType(ProjectManager.class);
        }
        return this.projectManager;
    }

    public VersionManager getVersionManager() {
        if (this.versionManager == null) {
            this.versionManager = this.getComponentInstanceOfType(VersionManager.class);
        }
        return this.versionManager;
    }

    private FieldManager getFieldManager() {
        if (this.fieldManager == null) {
            this.fieldManager = this.getComponentInstanceOfType(FieldManager.class);
        }
        return this.fieldManager;
    }

    private SearchSortUtil getSearchSortUtil() {
        if (this.searchSortUtil == null) {
            this.searchSortUtil = this.getComponentInstanceOfType(SearchSortUtil.class);
        }
        return this.searchSortUtil;
    }

    @Deprecated
    public OutlookDate getOutlookDate() {
        if (this.outlookDate == null) {
            this.outlookDate = this.getOutlookDateManager().getOutlookDate(this.getLocale());
        }
        return this.outlookDate;
    }

    private OutlookDateManager getOutlookDateManager() {
        if (this.outlookDateManager == null) {
            this.outlookDateManager = this.getComponentInstanceOfType(OutlookDateManager.class);
        }
        return this.outlookDateManager;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        if (this.dateTimeFormatter == null) {
            this.dateTimeFormatter = this.getComponentInstanceOfType(DateTimeFormatterFactory.class).formatter().forLoggedInUser().withStyle(DateTimeStyle.RELATIVE);
        }
        return this.dateTimeFormatter;
    }

    public DateTimeFormatter getDmyDateFormatter() {
        if (this.dmyDateFormatter == null) {
            this.dmyDateFormatter = this.getComponentInstanceOfType(DateTimeFormatterFactory.class).formatter().forLoggedInUser().withStyle(DateTimeStyle.DATE);
        }
        return this.dmyDateFormatter;
    }

    public JiraContactHelper getJiraContactHelper() {
        if (this.jiraContactHelper == null) {
            this.jiraContactHelper = this.getComponentInstanceOfType(JiraContactHelper.class);
        }
        return this.jiraContactHelper;
    }

    public UserManager getUserManager() {
        if (this.userManager == null) {
            this.userManager = this.getComponentInstanceOfType(UserManager.class);
        }
        return this.userManager;
    }

    public String getAdministratorContactLink() {
        return this.getJiraContactHelper().getAdministratorContactLinkHtml(this.request.getContextPath(), this.getI18nHelper());
    }

    private JiraLicenseService getJiraLicenseService() {
        if (this.jiraLicenseService == null) {
            this.jiraLicenseService = this.getComponentInstanceOfType(JiraLicenseService.class);
        }
        return this.jiraLicenseService;
    }

    protected final HintManager getHintManager() {
        if (this.hintManager == null) {
            this.hintManager = this.getComponentInstanceOfType(HintManager.class);
        }
        return this.hintManager;
    }

    protected AuthorizationSupport getAuthorizationSupport() {
        if (this.authorizationSupport == null) {
            this.authorizationSupport = this.getComponentInstanceOfType(AuthorizationSupport.class);
        }
        return this.authorizationSupport;
    }

    public String getRedirect(String defaultUrl) {
        if (this.getRedirectSanitiser().makeSafeRedirectUrl(defaultUrl) == null) {
            this.log.warn((Object)String.format("Redirecting to unsafe location '%s' using getRedirect(String). This will not work in JIRA 6.0: use getRedirect(String,boolean) instead.", defaultUrl));
        }
        return this.getRedirect(defaultUrl, false);
    }

    public String getRedirect(String defaultUrl, boolean allowUnsafeRedirect) {
        String redirectUrl;
        String unsafeRedirectUrl = StringUtils.isNotBlank((CharSequence)this.getReturnUrl()) ? this.getReturnUrl() : defaultUrl;
        String string = redirectUrl = allowUnsafeRedirect ? unsafeRedirectUrl : this.getRedirectSanitiser().makeSafeRedirectUrl(unsafeRedirectUrl);
        if (StringUtils.isBlank((CharSequence)redirectUrl)) {
            this.getErrorMessages().add(this.getI18nHelper().getText("webwork.action.redirect.error"));
        }
        this.setReturnUrl(null);
        if (this.invalidInput()) {
            return "error";
        }
        if (ServletActionContext.getResponse() == null) {
            String message = "Called a web action as if it were non-web";
            this.log.warn((Object)"Called a web action as if it were non-web", (Throwable)new RuntimeException("Called a web action as if it were non-web"));
            return "success";
        }
        return this.forceRedirect(this.rootLocation(redirectUrl));
    }

    private String rootLocation(String location) {
        if (StringUtils.isNotBlank((CharSequence)location) && location.charAt(0) == '/' && this.request != null) {
            return this.insertContextPath(location);
        }
        return location;
    }

    private String passReturnLocation(String location) {
        String returnUrl = this.getReturnUrl();
        if (StringUtils.isNotBlank((CharSequence)returnUrl)) {
            if (location.indexOf(63) == -1) {
                return location + "?returnUrl=" + JiraUrlCodec.encode(returnUrl);
            }
            return location + "&returnUrl=" + JiraUrlCodec.encode(returnUrl);
        }
        return location;
    }

    protected String forceRedirect(String redirect) {
        try {
            redirect = this.passReturnLocation(redirect);
            if (ServletActionContext.getResponse() != null) {
                ServletActionContext.getResponse().sendRedirect(redirect);
            }
        }
        catch (IOException e) {
            this.log.error((Object)("IOException trying to send redirect" + e), (Throwable)e);
        }
        return "none";
    }

    @Override
    public boolean hasPermission(int permissionsId) {
        return this.getAuthorizationSupport().hasPermission(permissionsId);
    }

    @Override
    public boolean hasGlobalPermission(GlobalPermissionKey globalPermissionKey) {
        return this.getAuthorizationSupport().hasGlobalPermission(globalPermissionKey);
    }

    @Override
    public boolean hasGlobalPermission(String permissionKey) {
        return this.getAuthorizationSupport().hasGlobalPermission(permissionKey);
    }

    @Override
    public boolean hasIssuePermission(String permissionKey, Issue issue) {
        return this.getAuthorizationSupport().hasIssuePermission(permissionKey, issue);
    }

    @Override
    public boolean hasIssuePermission(int permissionsId, Issue issue) {
        return this.getAuthorizationSupport().hasIssuePermission(permissionsId, issue);
    }

    @Override
    public boolean hasIssuePermission(ProjectPermissionKey projectPermissionKey, Issue issue) {
        return this.getAuthorizationSupport().hasIssuePermission(projectPermissionKey, issue);
    }

    @Override
    public boolean hasProjectPermission(int permissionsId, Project project) {
        return this.getAuthorizationSupport().hasProjectPermission(permissionsId, project);
    }

    @Override
    public boolean hasProjectPermission(ProjectPermissionKey projectPermissionKey, Project project) {
        return this.getAuthorizationSupport().hasProjectPermission(projectPermissionKey, project);
    }

    public boolean isSystemAdministrator() {
        ApplicationUser currentUser = this.getLoggedInUser();
        return currentUser != null && this.getGlobalPermissionManager().hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, currentUser);
    }

    public boolean isAdministrator() {
        ApplicationUser currentUser = this.getLoggedInUser();
        return currentUser != null && this.getGlobalPermissionManager().hasPermission(GlobalPermissionKey.ADMINISTER, currentUser);
    }

    @Deprecated
    public boolean isUserExists(String username) {
        return this.isUserExistsByName(username);
    }

    public boolean isUserExistsByName(String username) {
        return this.getUserManager().getUserByName(username) != null;
    }

    public boolean isUserExistsByKey(String userkey) {
        return this.getUserManager().getUserByKey(userkey) != null;
    }

    public String getUserFullName(String username) {
        ApplicationUser user = this.getUserManager().getUserByName(username);
        if (user == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Could not retrieve full name for user '" + username + "'! User does not exist!"));
            }
            return username;
        }
        return user.getDisplayName();
    }

    @Override
    public void addErrorCollection(ErrorCollection errors) {
        this.addErrorMessages(errors.getErrorMessages());
        this.addErrors(errors.getErrors());
        this.addReasons(errors.getReasons());
    }

    @Override
    public void addError(String field, String message, ErrorCollection.Reason reason) {
        this.addError(field, message);
        this.addReason(reason);
    }

    @Override
    public void addErrorMessage(String message, ErrorCollection.Reason reason) {
        this.addErrorMessage(message);
        this.addReason(reason);
    }

    @Override
    public void addReason(ErrorCollection.Reason reason) {
        this.reasons.add(reason);
    }

    @Override
    public void addReasons(Set<ErrorCollection.Reason> reasons) {
        this.reasons.addAll(reasons);
    }

    @Override
    public void setReasons(Set<ErrorCollection.Reason> reasons) {
        this.reasons = reasons;
    }

    @Override
    public Set<ErrorCollection.Reason> getReasons() {
        return this.reasons;
    }

    public Field getField(String id) {
        return this.getFieldManager().getField(id);
    }

    public List<String> getSearchSortDescriptions(SearchRequest searchRequest) {
        return this.getSearchSortUtil().getSearchSortDescriptions(searchRequest, this, this.getLoggedInUser());
    }

    public String getNameTranslation(GenericValue issueConstantGV) {
        return this.getNameTranslation(this.getConstantsManager().getIssueConstant(issueConstantGV));
    }

    public String getNameTranslation(IssueConstant issueConstant) {
        if (issueConstant != null) {
            return issueConstant.getNameTranslation();
        }
        return null;
    }

    public String getDescTranslation(GenericValue issueConstantGV) {
        return this.getDescTranslation(this.getConstantsManager().getIssueConstant(issueConstantGV));
    }

    public String getDescTranslation(IssueConstant issueConstant) {
        if (issueConstant != null) {
            return issueConstant.getDescTranslation();
        }
        return null;
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public String getReturnUrlForCancelLink() {
        if (StringUtils.contains((CharSequence)this.returnUrl, (CharSequence)"selectedIssueId")) {
            return SELECTED_ISSUE_PATTERN.matcher(this.returnUrl).replaceFirst("");
        }
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        String safeReturnUrl = returnUrl != null ? this.getUriValidator().getSafeUri(JiraUrl.constructBaseUrl(this.request), returnUrl) : null;
        this.returnUrl = this.getRedirectSanitiser().makeSafeRedirectUrl(safeReturnUrl);
    }

    @Override
    public Collection<String> getFlushedErrorMessages() {
        Collection<String> errors = this.getErrorMessages();
        this.errorMessages = new ArrayList();
        return errors;
    }

    public String getLanguage() throws IOException {
        return this.getLocale().getLanguage();
    }

    public Project getSelectedProject() {
        if (this.selectedProject == null) {
            this.selectedProject = this.getUserProjectHistoryManager().getCurrentProject(10, this.getLoggedInUser());
        }
        return this.selectedProject;
    }

    public Project getSelectedProjectObject() {
        return this.getSelectedProject();
    }

    public void setSelectedProjectId(Long id) {
        Project project;
        this.selectedProject = null;
        if (id != null && (project = this.getProjectManager().getProjectObj(id)) != null) {
            this.getUserProjectHistoryManager().addProjectToHistory(this.getLoggedInUser(), project);
        }
    }

    public String getDateFormat() {
        return DateTimeFormatUtils.getDateFormat();
    }

    public String getDateTimeFormat() {
        return DateTimeFormatUtils.getDateTimeFormat();
    }

    public String getTimeFormat() {
        return DateTimeFormatUtils.getTimeFormat();
    }

    public String getWebworkStack(String selected) {
        ValueStack stack = CoreActionContext.getValueStack();
        Object selectedObj = stack.findValue(selected);
        StringBuilder buf = new StringBuilder();
        buf.append("<pre>");
        Iterator iter = stack.iterator();
        boolean highlighted = false;
        while (iter.hasNext()) {
            Object o = iter.next();
            buf.append("<ul><li>");
            if (o == selectedObj) {
                highlighted = true;
                buf.append("<font color='red'>");
                buf.append(o);
                buf.append("</font>");
                continue;
            }
            buf.append(o);
        }
        buf.append("</pre>");
        if (!highlighted && selected != null) {
            buf.append("<font color='red'>");
            buf.append(selected);
            buf.append(" resolves to: ");
            buf.append(selectedObj);
            buf.append("</font>");
        }
        return buf.toString();
    }

    public String getWebworkStack() {
        return this.getWebworkStack(null);
    }

    public String getServerId() {
        return this.getJiraLicenseService().getServerId();
    }

    public JiraServiceContext getJiraServiceContext() {
        return new JiraServiceContextImpl(this.getLoggedInUser(), this);
    }

    @HtmlSafe
    public String htmlEncode(String encodeMe) {
        return TextUtils.htmlEncode((String)encodeMe);
    }

    @HtmlSafe
    public String urlEncode(String encode) {
        try {
            return URLEncoder.encode(encode, this.getApplicationProperties().getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            return URLEncoder.encode(encode);
        }
    }

    public boolean isInlineDialogMode() {
        return this.inline;
    }

    public RequestSourceType getRequestSourceType() {
        return this.inline ? RequestSourceType.DIALOG : RequestSourceType.PAGE;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public String returnComplete() {
        return this.returnComplete(null);
    }

    public String returnComplete(String url) {
        if (this.isInlineDialogMode()) {
            return this.inlineDialogControl("DONE");
        }
        return this.returnWebResponse(url);
    }

    public String getEmptyResponse() {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setStatus(204);
        return "none";
    }

    protected final String returnCompleteWithInlineRedirect(String url) {
        if (this.isInlineDialogMode()) {
            return this.inlineDialogControl("redirect:" + this.insertContextPath(url));
        }
        return this.returnWebResponse(url);
    }

    protected String returnCompleteWithInlineRedirectAndMsg(String url, String msg, MessageType type, boolean closeable, @Nullable String target) {
        return this.returnCompleteWithInlineRedirectAndMsg(url, msg, type.asWebParameter(), closeable, target);
    }

    protected String returnCompleteWithInlineRedirectAndMsg(String url, String msg, String type, boolean closeable, @Nullable String target) {
        if (this.isInlineDialogMode()) {
            this.addMessageToResponse(msg, type, closeable, target);
            return this.inlineDialogControl("redirect:" + this.insertContextPath(url));
        }
        return this.returnWebResponse(url);
    }

    @Deprecated
    protected String returnMsgToUser(String url, String msg, String type, boolean closeable, @Nullable String target) {
        this.addMessageToResponse(msg, type, closeable, target);
        return this.returnComplete(url);
    }

    protected String returnMsgToUser(String url, String msg, MessageType type, boolean closeable, @Nullable String target) {
        return this.returnMsgToUser(url, msg, type.asWebParameter(), closeable, target);
    }

    protected String insertContextPath(String url) {
        if (url.startsWith("/")) {
            String contextPath = this.request.getContextPath();
            url = contextPath == null ? url : contextPath + url;
        }
        return url;
    }

    private String returnWebResponse(String url) {
        if (StringUtils.isNotBlank((CharSequence)url)) {
            if (url.equals("success") || url.equals("error") || url.equals("input") || url.equals("login") || url.equals("none")) {
                return url;
            }
            return this.getRedirect(url);
        }
        return "success";
    }

    private String inlineDialogControl(String headerValue) {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setStatus(200);
        response.setHeader(X_ATLASSIAN_DIALOG_CONTROL, headerValue);
        return "none";
    }

    protected void addMessageToResponse(String msg, String type, boolean closeable, String target) {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setHeader(X_ATLASSIAN_DIALOG_MSG_HTML, msg);
        response.setHeader(X_ATLASSIAN_DIALOG_MSG_TYPE, type);
        response.setHeader(X_ATLASSIAN_DIALOG_MSG_CLOSEABLE, String.valueOf(closeable));
        response.setHeader(X_ATLASSIAN_DIALOG_MSG_TARGET, target);
    }

    protected final boolean hasErrorMessage(String errorMsg) {
        return this.getErrorMessages().contains(errorMsg);
    }

    protected final boolean hasErrorMessageByKey(String errorMsgKey) {
        return this.hasErrorMessage(this.getText(errorMsgKey));
    }

    protected final void addErrorMessageIfAbsent(String errorMsg) {
        if (!this.hasErrorMessage(errorMsg)) {
            this.addErrorMessage(errorMsg);
        }
    }

    protected final void addErrorMessageByKeyIfAbsent(String errorMsgKey) {
        this.addErrorMessageIfAbsent(this.getText(errorMsgKey));
    }

    protected void tagMauEventWithApplication(@Nonnull MauApplicationKey applicationKey) {
        MauEventService service = this.mauEventService.get();
        if (service != null) {
            service.setApplicationForThread(applicationKey);
        }
    }

    protected void tagMauEventWithProject(Project project) {
        MauEventService service = this.mauEventService.get();
        if (service != null) {
            service.setApplicationForThreadBasedOnProject(project);
        }
    }

    public final Hint getHint(String context) {
        try {
            HintManager.Context realContext = HintManager.Context.valueOf(context.toUpperCase());
            return this.getHintManager().getHintForContext(this.getLoggedInUser(), new JiraHelper(ActionContext.getRequest()), realContext);
        }
        catch (IllegalArgumentException e) {
            this.log.warn((Object)("Illegal hint context '" + context + "' specified!"));
            return null;
        }
    }

    public final Hint getRandomHint() {
        return this.getHintManager().getRandomHint(this.getLoggedInUser(), new JiraHelper(ActionContext.getRequest()));
    }

    public String getConglomerateCookieValue(String cookieName, String key) {
        Map<String, String> map = CookieUtils.parseConglomerateCookie(cookieName, ActionContext.getRequest());
        String value = map.get(key);
        return value != null ? value : "";
    }

    public void setConglomerateCookieValue(String cookieName, String key, String value) {
        Map<String, String> map = CookieUtils.parseConglomerateCookie(cookieName, ActionContext.getRequest());
        if (StringUtils.isNotBlank((CharSequence)value)) {
            map.put(key, value);
        } else {
            map.remove(key);
        }
        Cookie cookie = CookieUtils.createConglomerateCookie(cookieName, map, ActionContext.getRequest());
        ActionContext.getResponse().addCookie(cookie);
    }

    @Nonnull
    protected final RedirectSanitiser getRedirectSanitiser() {
        RedirectSanitiser safeRedirectProvider = this.safeRedirectProvider;
        if (safeRedirectProvider == null) {
            safeRedirectProvider = ComponentAccessor.getComponent(RedirectSanitiser.class);
            this.safeRedirectProvider = Assertions.notNull("RedirectSanitiser is not registered in ComponentAccessor", safeRedirectProvider);
        }
        return safeRedirectProvider;
    }

    @Override
    public Collection<String> getErrorMessages() {
        return super.getErrorMessages();
    }

    @Override
    public Map<String, String> getErrors() {
        return super.getErrors();
    }

    @Override
    public Set<String> getKeysForPrefix(String prefix) {
        throw new UnsupportedOperationException("This method should only be called via the I18nBean and is only required for SAL.");
    }

    @Override
    public ResourceBundle getDefaultResourceBundle() {
        return this.getI18nHelper().getDefaultResourceBundle();
    }

    @Override
    public String getUnescapedText(String key) {
        return this.getI18nHelper().getUnescapedText(key);
    }

    @Override
    public String getUntransformedRawText(String key) {
        return this.getI18nHelper().getUntransformedRawText(key);
    }

    @Override
    public boolean isKeyDefined(String key) {
        return this.getI18nHelper().isKeyDefined(key);
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.getI18nHelper().getResourceBundle();
    }

    @Override
    @HtmlSafe
    public String getText(String key) {
        return this.getI18nHelper().getText(key);
    }

    @Override
    @HtmlSafe
    public String getText(String key, String value1) {
        return this.getI18nHelper().getText(key, value1);
    }

    @Override
    @HtmlSafe
    public String getText(String key, String value1, String value2) {
        return this.getI18nHelper().getText(key, value1, value2);
    }

    @Override
    @HtmlSafe
    public String getText(String key, String value1, String value2, String value3) {
        return this.getI18nHelper().getText(key, value1, value2, value3);
    }

    @Override
    @HtmlSafe
    public String getText(String key, String value1, String value2, String value3, String value4) {
        return this.getI18nHelper().getText(key, value1, value2, value3, value4);
    }

    @Override
    @HtmlSafe
    public String getText(String key, Object value1, Object value2, Object value3) {
        return this.getI18nHelper().getText(key, value1, value2, value3);
    }

    @Override
    @HtmlSafe
    public String getText(String key, Object value1, Object value2, Object value3, Object value4) {
        return this.getI18nHelper().getText(key, value1, value2, value3, value4);
    }

    @Override
    @HtmlSafe
    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5) {
        return this.getI18nHelper().getText(key, value1, value2, value3, value4, value5);
    }

    @Override
    @HtmlSafe
    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6) {
        return this.getI18nHelper().getText(key, value1, value2, value3, value4, value5, value6);
    }

    @Override
    @HtmlSafe
    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7) {
        return this.getI18nHelper().getText(key, value1, value2, value3, value4, value5, value6, value7);
    }

    @Override
    @HtmlSafe
    public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7) {
        return this.getI18nHelper().getText(key, value1, value2, value3, value4, value5, value6, value7);
    }

    @Override
    @HtmlSafe
    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7, Object value8) {
        return this.getI18nHelper().getText(key, value1, value2, value3, value4, value5, value6, value7, value8);
    }

    @Override
    @HtmlSafe
    public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7, String value8, String value9) {
        return this.getI18nHelper().getText(key, value1, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    @Override
    @HtmlSafe
    public String getText(String key, Object parameters) {
        return this.getI18nHelper().getText(key, parameters);
    }

    public Preferences getUserPreferences() {
        if (this.userPrefs == null) {
            this.userPrefs = this.getComponentInstanceOfType(UserPreferencesManager.class).getPreferences(ComponentAccessor.getJiraAuthenticationContext().getUser());
        }
        return this.userPrefs;
    }

    protected I18nHelper getI18nHelper() {
        if (this.i18nHelperDelegate == null) {
            this.i18nHelperDelegate = this.getComponentInstanceOfType(JiraAuthenticationContext.class).getI18nHelper();
        }
        return this.i18nHelperDelegate;
    }

    @Override
    public Locale getLocale() {
        return this.getI18nHelper().getLocale();
    }

    public boolean isIndexing() {
        return true;
    }

    protected void removeKeyOrAddError(Map params, String key, String messageKey) {
        if (params.containsKey(key)) {
            params.remove(key);
        } else {
            this.addErrorMessage(this.getText(messageKey));
        }
    }

    public String execute() throws Exception {
        try (Ticker ignored = Timers.start((String)(this.getActionName() + ".execute()"));){
            String string = super.execute();
            return string;
        }
    }

    public final String getActionName() {
        String classname = this.getClass().getName();
        return classname.substring(classname.lastIndexOf(46) + 1);
    }

    public String getResult() {
        return this.invalidInput() ? "error" : "success";
    }

    @Override
    public void addErrorMessages(Collection<String> errorMessages) {
        if (errorMessages == null) {
            return;
        }
        for (String errorMessage : errorMessages) {
            this.addErrorMessage(errorMessage);
        }
    }

    @Override
    public void addErrors(Map<String, String> errors) {
        if (errors == null) {
            return;
        }
        for (Map.Entry<String, String> mapEntry : errors.entrySet()) {
            String name = mapEntry.getKey();
            String error = mapEntry.getValue();
            this.addError(name, error);
        }
    }

    @Override
    public boolean hasAnyErrors() {
        return !this.getErrors().isEmpty() || !this.getErrorMessages().isEmpty();
    }

    public void addErrorMessages(ActionResult aResult) {
        if (!"success".equals(aResult.getResult())) {
            ActionSupport actionSupport = (ActionSupport)aResult.getFirstAction();
            this.addErrorMessages(actionSupport.getErrorMessages());
        }
    }

    public void addIllegalArgumentException(String fieldName, IllegalArgumentException e) {
        String msg = e.getMessage();
        if (e instanceof PropertyEditorException) {
            msg = this.getPropertyEditorMessage(fieldName, (PropertyEditorException)e);
        }
        if (msg == null || !msg.startsWith("missing matching end quote")) {
            this.addError(fieldName, msg);
        }
    }

    public OfBizDelegator getOfBizDelegator() {
        if (this.ofBizDelegator == null) {
            this.ofBizDelegator = ComponentAccessor.getComponent(OfBizDelegator.class);
        }
        return this.ofBizDelegator;
    }

    protected <T> T getComponentInstanceOfType(Class<T> clazz) {
        return ComponentAccessor.getComponentOfType(clazz);
    }

    public static enum MessageType {
        ERROR,
        WARNING,
        SUCCESS;


        public String asWebParameter() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

