/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.fugue.Pair;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.AttachmentKeys;
import com.atlassian.jira.issue.attachment.AttachmentRuntimeException;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.collect.Transformed;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public final class ConsumeAllAttachmentKeys {
    private ConsumeAllAttachmentKeys() {
    }

    public static EnclosedIterable<Pair<Attachment, AttachmentKey>> getAttachmentsWithKeys(EnclosedIterable<Attachment> attachments, IssueManager issueManager) {
        final Map<Long, Keys> issues = ConsumeAllAttachmentKeys.getIssueKeysFromIds(issueManager, ConsumeAllAttachmentKeys.getIssuesIdsForAttachments(attachments));
        return Transformed.enclosedIterable(attachments, (Function)new Function<Attachment, Pair<Attachment, AttachmentKey>>(){

            public Pair<Attachment, AttachmentKey> get(Attachment attachment) {
                Keys keys = (Keys)issues.get(attachment.getIssueId());
                return Pair.pair((Object)attachment, (Object)AttachmentKeys.from(keys.projectKey, keys.issueKey, attachment));
            }
        });
    }

    private static Map<Long, Keys> getIssueKeysFromIds(IssueManager issueManager, Set<Long> issuesId) {
        HashMap<Long, Keys> issues = new HashMap<Long, Keys>();
        for (Long id : issuesId) {
            MutableIssue issue = issueManager.getIssueObject(id);
            if (issue == null) {
                throw new AttachmentRuntimeException("Issue with id " + id + " does not exist!");
            }
            issues.put(issue.getId(), new Keys((Issue)issue));
        }
        return issues;
    }

    private static Set<Long> getIssuesIdsForAttachments(EnclosedIterable<Attachment> attachments) {
        final HashSet<Long> issuesId = new HashSet<Long>();
        attachments.foreach((Consumer)new Consumer<Attachment>(){

            public void consume(@Nonnull Attachment attachment) {
                issuesId.add(attachment.getIssueId());
            }
        });
        return issuesId;
    }

    private static final class Keys {
        public final String issueKey;
        public final String projectKey;

        public Keys(Issue issue) {
            this.issueKey = issue.getKey();
            this.projectKey = issue.getProjectObject().getOriginalKey();
        }
    }
}

