/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.jira.issue.attachment.AttachmentGetData;
import com.atlassian.jira.util.RuntimeIOException;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.IOUtils;

@ThreadSafe
public class AttachmentFileGetData
implements AttachmentGetData {
    final File file;
    InputStream inputStream;
    boolean closed = false;
    final ReentrantLock lock = new ReentrantLock();

    public AttachmentFileGetData(File file) {
        this.file = (File)Preconditions.checkNotNull((Object)file, (Object)"file");
    }

    public File getFile() {
        return this.file;
    }

    public void close() {
        InputStream prevValue;
        this.lock.lock();
        try {
            prevValue = this.inputStream;
            this.inputStream = null;
            this.closed = true;
        }
        finally {
            this.lock.unlock();
        }
        if (prevValue != null) {
            IOUtils.closeQuietly((InputStream)prevValue);
        }
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public InputStream getInputStream() {
        this.lock.lock();
        try {
            if (this.inputStream != null) {
                throw new IllegalStateException("Input stream already obtained");
            }
            if (this.closed) {
                throw new IllegalStateException("This object was already closed");
            }
            try {
                this.inputStream = new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeIOException((IOException)e);
            }
            InputStream inputStream = this.inputStream;
            return inputStream;
        }
        finally {
            this.lock.unlock();
        }
    }
}

