/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.Function;
import com.atlassian.util.concurrent.ExceptionPolicy;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CallableFunction<I, O> {
    private static final Logger log = LoggerFactory.getLogger(CallableFunction.class);
    private final Function<I, O> function;
    private final ExceptionPolicy exceptionPolicy;

    public CallableFunction(@Nonnull Function<I, O> function, @Nonnull ExceptionPolicy exceptionPolicy) {
        this.function = (Function)Preconditions.checkNotNull(function);
        this.exceptionPolicy = (ExceptionPolicy)Preconditions.checkNotNull((Object)exceptionPolicy);
    }

    public Callable<O> apply(I input) {
        return new InputProcessorCallable(input);
    }

    private class InputProcessorCallable
    implements Callable<O> {
        private final I input;

        public InputProcessorCallable(I input) {
            this.input = input;
        }

        @Override
        public O call() {
            if (log.isDebugEnabled()) {
                log.debug("Processing input: {}", this.input);
            }
            try {
                return CallableFunction.this.function.get(this.input);
            }
            catch (RuntimeException e) {
                return ((Supplier)CallableFunction.this.exceptionPolicy.handler().apply((Object)new Supplier<O>(){

                    public O get() {
                        throw e;
                    }
                })).get();
            }
        }
    }
}

