/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.ofbiz.actions.index;

import com.atlassian.core.ofbiz.util.database.mssql.MSSQLIndexUtil;
import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Optional;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;
import org.ofbiz.core.entity.jdbc.alternative.IndexAlternativeAction;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSSQLIncludedIndexAlternativeAction
implements IndexAlternativeAction {
    private static final Logger log = LoggerFactory.getLogger(MSSQLIncludedIndexAlternativeAction.class);
    private final String tableName;
    private final String indexName;
    private final List<String> indexedColumnsNames;
    private final List<String> includedColumnsNames;
    private final int indexSizeToTrigger;
    private final boolean unique;

    public MSSQLIncludedIndexAlternativeAction(String tableName, String indexName, List<String> indexedColumnsNames, List<String> includedColumnsNames, int indexSizeToTrigger) {
        this(tableName, indexName, indexedColumnsNames, includedColumnsNames, indexSizeToTrigger, false);
    }

    public MSSQLIncludedIndexAlternativeAction(String tableName, String indexName, List<String> indexedColumnsNames, List<String> includedColumnsNames, int indexSizeToTrigger, boolean unique) {
        this.tableName = tableName;
        this.indexName = indexName;
        this.indexedColumnsNames = indexedColumnsNames;
        this.includedColumnsNames = includedColumnsNames;
        this.indexSizeToTrigger = indexSizeToTrigger;
        this.unique = unique;
    }

    private String createSchemaNameWithDot() {
        return Optional.ofNullable(DefaultOfBizConnectionFactory.getInstance().getDatasourceInfo().getSchemaName()).map(String::trim).filter(x -> !x.isEmpty()).map(x -> x + ".").orElse("");
    }

    public boolean shouldRun(ModelEntity modelEntity, ModelIndex modelIndex, DatabaseUtil dbUtil) throws SQLException, GenericEntityException {
        this.checkTableNameAndIndexNameCorrectness(modelEntity, modelIndex);
        return this.isSQLServerAndIndexKeySizeExceedsLimit(dbUtil);
    }

    private boolean isSQLServerAndIndexKeySizeExceedsLimit(DatabaseUtil dbUtil) throws SQLException, GenericEntityException {
        try (Connection conn = dbUtil.getConnection();){
            int majorVersion = MSSQLIndexUtil.getDbMajorVersion(conn);
            boolean bl = MSSQLIndexUtil.isSqlServer(conn) && MSSQLIndexUtil.getUnclusteredMaximumKeySizeForMajorVersion(majorVersion) <= this.indexSizeToTrigger;
            return bl;
        }
    }

    private void checkTableNameAndIndexNameCorrectness(ModelEntity modelEntity, ModelIndex modelIndex) {
        if (!modelEntity.getPlainTableName().equals(this.tableName) || !modelIndex.getName().equals(this.indexName)) {
            throw new IllegalArgumentException(String.format("Alternative execution not used with correct index %s.%s!", this.tableName, this.indexName));
        }
    }

    public String run(ModelEntity modelEntity, ModelIndex modelIndex, DatabaseUtil dbUtil) throws SQLException, GenericEntityException {
        try (Connection conn = dbUtil.getConnection();
             Statement statement = conn.createStatement();){
            String sql = this.createSQLForIncludedIndex();
            statement.execute(sql);
            log.debug("Alternative index creation ran with SQL: " + sql);
        }
        return null;
    }

    private String createSQLForIncludedIndex() {
        String sqlTemplate = this.unique ? "CREATE UNIQUE INDEX %s ON %s (%s) INCLUDE (%s)" : "CREATE INDEX %s ON %s (%s) INCLUDE (%s)";
        String tableNameWithSchema = this.createSchemaNameWithDot() + this.tableName;
        String indexedColumnsJoined = String.join((CharSequence)", ", this.indexedColumnsNames);
        String includedColumnsJoined = String.join((CharSequence)", ", this.includedColumnsNames);
        return String.format(sqlTemplate, this.indexName, tableNameWithSchema, indexedColumnsJoined, includedColumnsJoined);
    }
}

