/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.util;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import webwork.action.ActionContext;

public class WebRequestUtils {
    public static final int OTHER = 0;
    public static final int OPERA = 10;
    public static final int WINDOWS = 10;
    public static final int MACOSX = 20;
    public static final int LINUX = 30;

    public static boolean isGoodBrowser(HttpServletRequest request) {
        String userAgent = request.getHeader("USER-AGENT");
        return userAgent != null && (userAgent.indexOf("MSIE") != -1 || userAgent.indexOf("Mozilla/5") != -1 || userAgent.indexOf("Opera") != -1);
    }

    public static int getBrowser(HttpServletRequest request) {
        String userAgent = request.getHeader("USER-AGENT");
        if (userAgent == null) {
            return 0;
        }
        if (userAgent.indexOf("Opera") != -1) {
            return 10;
        }
        return 0;
    }

    public static int getBrowserOperationSystem(HttpServletRequest request) {
        String userAgent;
        String string = userAgent = request != null ? request.getHeader("USER-AGENT") : null;
        if (userAgent != null) {
            if ((userAgent = userAgent.toLowerCase()).indexOf("windows") != -1) {
                return 10;
            }
            if (userAgent.indexOf("mac os x") != -1) {
                return 20;
            }
            if (userAgent.indexOf("linux") != -1) {
                return 30;
            }
            return 0;
        }
        return 0;
    }

    public static String getModifierKey() {
        HttpServletRequest request = ActionContext.getRequest();
        if (request != null) {
            String userAgent = StringUtils.lowerCase((String)request.getHeader("USER-AGENT"));
            if (StringUtils.contains((CharSequence)userAgent, (CharSequence)"safari") || StringUtils.contains((CharSequence)userAgent, (CharSequence)"mac")) {
                return "Ctrl";
            }
            if (StringUtils.contains((CharSequence)userAgent, (CharSequence)"opera")) {
                return "Shift + Esc";
            }
        }
        return "Alt";
    }
}

