/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diff;

import com.atlassian.diff.CharacterChunk;
import com.atlassian.diff.DiffType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jrcs.diff.AddDelta;
import org.apache.commons.jrcs.diff.ChangeDelta;
import org.apache.commons.jrcs.diff.Chunk;
import org.apache.commons.jrcs.diff.DeleteDelta;
import org.apache.commons.jrcs.diff.Delta;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.commons.jrcs.diff.Revision;
import org.apache.commons.lang3.StringUtils;

public class CharLevelDiffer {
    static List<CharacterChunk> getCharacterChunks(String originalText, String revisedText) throws DifferentiationFailedException {
        Object[] revdChars;
        if (StringUtils.isBlank((CharSequence)originalText) || StringUtils.isBlank((CharSequence)revisedText)) {
            return null;
        }
        Object[] origChars = CharLevelDiffer.getCharacters(originalText);
        Revision revision = new Diff(origChars).diff(revdChars = CharLevelDiffer.getCharacters(revisedText));
        int numDeltas = revision.size();
        if (numDeltas > 2) {
            return null;
        }
        Chunk previousOriginalChunk = null;
        ArrayList<CharacterChunk> charChunks = new ArrayList<CharacterChunk>();
        for (int deltaIndex = 0; deltaIndex < numDeltas; ++deltaIndex) {
            Delta delta = revision.getDelta(deltaIndex);
            if (delta instanceof ChangeDelta) {
                return null;
            }
            Chunk originalChunk = delta.getOriginal();
            Chunk revisedChunk = delta.getRevised();
            List originalChunkChars = originalChunk.chunk();
            List revisedChunkChars = revisedChunk.chunk();
            CharacterChunk unchangedChunk = CharLevelDiffer.getUnchangedCharsBetweenChunks(originalText, previousOriginalChunk, originalChunk);
            if (unchangedChunk != null) {
                charChunks.add(unchangedChunk);
            }
            if (delta instanceof DeleteDelta || delta instanceof ChangeDelta) {
                String deletedChunkText = StringUtils.join((Iterable)originalChunkChars, (String)"");
                charChunks.add(new CharacterChunk(DiffType.DELETED_CHARACTERS, deletedChunkText));
            }
            if (delta instanceof AddDelta || delta instanceof ChangeDelta) {
                String addedChunkText = StringUtils.join((Iterable)revisedChunkChars, (String)"");
                charChunks.add(new CharacterChunk(DiffType.ADDED_CHARACTERS, addedChunkText));
            }
            previousOriginalChunk = originalChunk;
        }
        CharacterChunk unchangedChunk = CharLevelDiffer.getUnchangedCharsBetweenChunks(originalText, previousOriginalChunk, null);
        if (unchangedChunk != null) {
            charChunks.add(unchangedChunk);
        }
        return charChunks;
    }

    static CharacterChunk getUnchangedCharsBetweenChunks(String originalContent, Chunk chunkBefore, Chunk chunkAfter) {
        int unchangedEnd;
        int unchangedStart = chunkBefore != null ? chunkBefore.last() + 1 : 0;
        int n = unchangedEnd = chunkAfter != null ? chunkAfter.first() : originalContent.length();
        if (unchangedEnd <= unchangedStart) {
            return null;
        }
        String chunkText = originalContent.substring(unchangedStart, unchangedEnd);
        return new CharacterChunk(DiffType.UNCHANGED, chunkText);
    }

    private static Character[] getCharacters(CharSequence string) {
        Character[] chars = new Character[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            chars[i] = Character.valueOf(string.charAt(i));
        }
        return chars;
    }
}

