/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.action.component;

import com.atlassian.jira.action.component.SelectComponentAssigneesUtil;
import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentService;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.ComponentAssigneeTypes;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericEntityException;

public class SelectComponentAssigneesUtilImpl
implements SelectComponentAssigneesUtil {
    private Map<ProjectComponent, Long> componentAssigneeTypes;
    private String fieldPrefix;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectComponentService projectComponentService;
    private PermissionManager permissionManager;

    public SelectComponentAssigneesUtilImpl(JiraAuthenticationContext authenticationContext, ProjectComponentService projectComponentService, PermissionManager permissionManager) {
        this.authenticationContext = authenticationContext;
        this.projectComponentService = projectComponentService;
        this.permissionManager = permissionManager;
    }

    @Override
    public ErrorCollection validate() {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Set<ProjectComponent> components = this.componentAssigneeTypes.keySet();
        for (ProjectComponent component : components) {
            Long assigneeType;
            if (this.isAssigneeTypeValid(component, assigneeType = this.componentAssigneeTypes.get(component))) continue;
            errorCollection.addError(this.fieldPrefix + component.getId(), this.authenticationContext.getI18nHelper().getText("admin.errors.invalid.default.assignee"));
        }
        return errorCollection;
    }

    @Override
    public boolean hasPermission(Project project, ApplicationUser user) {
        return this.permissionManager.hasPermission(0, user) || this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user);
    }

    @Override
    public ErrorCollection execute(ApplicationUser user) throws GenericEntityException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Set<Map.Entry<ProjectComponent, Long>> componentEntries = this.componentAssigneeTypes.entrySet();
        for (Map.Entry<ProjectComponent, Long> entry : componentEntries) {
            Long assigneeType = entry.getValue();
            Long componentId = entry.getKey().getId();
            MutableProjectComponent projectComponent = MutableProjectComponent.copy((ProjectComponent)this.projectComponentService.find(user, (ErrorCollection)errorCollection, componentId));
            projectComponent.setAssigneeType(assigneeType.longValue());
            this.projectComponentService.update(user, (ErrorCollection)errorCollection, projectComponent);
        }
        return errorCollection;
    }

    private boolean isAssigneeTypeValid(ProjectComponent component, Long assigneeType) {
        return ComponentAssigneeTypes.isAssigneeTypeValid(component.getGenericValue(), assigneeType);
    }

    @Override
    public Map getComponentAssigneeTypes() {
        return this.componentAssigneeTypes;
    }

    @Override
    public void setComponentAssigneeTypes(Map<ProjectComponent, Long> componentAssigneeTypes) {
        this.componentAssigneeTypes = componentAssigneeTypes;
    }

    @Override
    public String getFieldPrefix() {
        return this.fieldPrefix;
    }

    @Override
    public void setFieldPrefix(String fieldPrefix) {
        this.fieldPrefix = fieldPrefix;
    }
}

