/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.analytics;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.analytics.AnalyticsEvent;
import com.atlassian.jira.util.stats.JiraStatsListener;
import com.atlassian.jira.util.stats.ManagedStats;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

public class AnalyticsSender
implements JiraStatsListener {
    private final EventPublisher eventPublisher;
    private final BiFunction<Map, Map, AnalyticsEvent> eventCreator;

    public static void registerAnalyticsSender(ManagedStats managedStats, EventPublisher eventPublisher, BiFunction<Map, Map, AnalyticsEvent> eventCreator) {
        AnalyticsSender analyticsSender = new AnalyticsSender(eventPublisher, eventCreator);
        managedStats.addJiraStatsListener((JiraStatsListener)analyticsSender);
    }

    public AnalyticsSender(EventPublisher eventPublisher, BiFunction<Map, Map, AnalyticsEvent> eventCreator) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.eventCreator = Objects.requireNonNull(eventCreator);
    }

    public void onStats(@Nullable Map snapshot, @Nullable Map total) {
        this.eventPublisher.publish((Object)this.eventCreator.apply(snapshot, total));
    }
}

