/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency;

import com.atlassian.jira.appconsistency.FakeHealthCheckEvent;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.health.AbstractHealthCheck;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.health.checks.CustomisedConfigurationsHealthCheck;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.web.servlet.JohnsonConfigMigrationServlet;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class FakeHealthCheck
extends AbstractHealthCheck {
    static final String SIMULATE_FAILURE_FOR_INTEGRATION_TESTS_SYSPROP = "jira.johnson.simulate.failure";
    private static final Set<String> filesList = Sets.newHashSet((Object[])new String[]{"server.xml", "jira.cfg.xml", "Please note that these file names are just hardcoded strings in FakeHealthCheck. Clicking Copy Configuration will do nothing"});
    @Nonnull
    private final Map<LifecyclePhase, List<FakeHealthCheckEvent>> phases;
    private static int errorIndex;

    public FakeHealthCheck() {
        this(JiraSystemProperties.getInstance());
    }

    @VisibleForTesting
    FakeHealthCheck(JiraProperties systemProperties) {
        super(Collections.emptyList());
        this.phases = FakeHealthCheck.extractPhases(systemProperties.getProperty(SIMULATE_FAILURE_FOR_INTEGRATION_TESTS_SYSPROP));
    }

    @VisibleForTesting
    static Map<LifecyclePhase, List<FakeHealthCheckEvent>> extractPhases(String systemProperty) {
        if (systemProperty == null) {
            return Collections.emptyMap();
        }
        try {
            return Arrays.stream(systemProperty.split(";")).map(phase -> Arrays.asList(phase.split(":"))).collect(Collectors.toMap(phaseAndError -> LifecyclePhase.valueOf((String)phaseAndError.get(0)), phaseAndError -> Arrays.stream(((String)phaseAndError.get(1)).split(",")).map(FakeHealthCheckEvent::createPhase).collect(Collectors.toList())));
        }
        catch (Exception e) {
            throw new RuntimeException("Incorrect format for phase to error map, string should look like \"POST_DATABASE_ACTIVATED:error,warning-dismissible;PLUGINS_STARTUP_FINISHED:error-dismissible\"", e);
        }
    }

    @Override
    public List<HealthCheckResult> perform(LifecyclePhase lifecyclePhase) {
        return this.phases.getOrDefault((Object)lifecyclePhase, Collections.emptyList()).stream().map(this::createHealthCheckResultForEventLevel).collect(Collectors.toList());
    }

    @Override
    public boolean isApplicableFor(LifecyclePhase phase) {
        return this.phases.containsKey((Object)phase);
    }

    private HealthCheckResult createHealthCheckResultForEventLevel(FakeHealthCheckEvent fakeHealthCheckEvent) {
        EventLevel level = fakeHealthCheckEvent.getLevel();
        Event event = new Event(new EventType("errorType" + errorIndex, "errorDescription" + errorIndex), "description" + errorIndex, "exception" + errorIndex, level);
        if (fakeHealthCheckEvent.isDismissible()) {
            event.addAttribute((Object)"dismissible", (Object)true);
        }
        if (fakeHealthCheckEvent.isConfigCustomisation()) {
            event.addAttribute((Object)"templateContext", (Object)new CustomisedConfigurationsHealthCheck.ConfigCustomisationTemplateContext(filesList, filesList));
        }
        if (fakeHealthCheckEvent.isConfigCustomisationReadOnly()) {
            event.addAttribute((Object)"templateContext", (Object)new CustomisedConfigurationsHealthCheck.ConfigCustomisationTemplateContext(Collections.emptySet(), filesList));
        }
        if (fakeHealthCheckEvent.isConfigCustomisationSuccess()) {
            event.addAttribute((Object)"templateContext", (Object)new JohnsonConfigMigrationServlet.SuccessTemplateContext(9));
        }
        HealthCheckResult result = HealthCheckResult.fail(this, event, UrlBuilder.createURL((String)"http://kburl"), "cause", "logmessage").get(0);
        ++errorIndex;
        return result;
    }
}

