/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application.install;

import com.atlassian.jira.application.install.BundlesVersionDiscovery;
import com.atlassian.jira.application.install.ReversibleFileOperations;
import com.atlassian.jira.application.install.WhatWasInstalledInApplication;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhatWasInstalledInApplicationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(WhatWasInstalledInApplicationFactory.class);
    @VisibleForTesting
    static final String CANNOT_READ_PROPS_MESSAGE = "Cannot load installed applications information from %s. Treating as not installed.";
    private static final Charset CONFIG_ENCODING = Charsets.UTF_8;

    public WhatWasInstalledInApplication load(File file) throws IOException {
        Object pluginIdentifications = ImmutableList.of();
        try {
            if (file.canRead()) {
                pluginIdentifications = this.loadPluginIdentificationsFromFile(file);
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format(CANNOT_READ_PROPS_MESSAGE, file.getAbsolutePath()), (Throwable)e);
        }
        return new WhatWasInstalledInApplication((Iterable<BundlesVersionDiscovery.PluginIdentification>)pluginIdentifications);
    }

    public WhatWasInstalledInApplication load(Iterable<BundlesVersionDiscovery.PluginIdentification> pluginIdentifications) {
        return new WhatWasInstalledInApplication(pluginIdentifications);
    }

    public void store(File applicationInstallInfoFile, WhatWasInstalledInApplication whatapp, ReversibleFileOperations reversibleFileOperations) throws IOException {
        Map<String, String> pluginsAsMap = whatapp.getPluginIdentifications().stream().collect(Collectors.toMap(BundlesVersionDiscovery.PluginIdentification::getSymbolicName, pluginIdentification -> pluginIdentification.getVersion().toString()));
        Properties properties = new Properties();
        properties.putAll(pluginsAsMap);
        Files.createDirectories(applicationInstallInfoFile.getParentFile().toPath(), new FileAttribute[0]);
        reversibleFileOperations.fileDelete(applicationInstallInfoFile);
        reversibleFileOperations.removeOnRollback(applicationInstallInfoFile);
        try (BufferedWriter outputStream = Files.newBufferedWriter(applicationInstallInfoFile.toPath(), CONFIG_ENCODING, new OpenOption[0]);){
            properties.store(outputStream, "-- application installation info --");
        }
    }

    private List<BundlesVersionDiscovery.PluginIdentification> loadPluginIdentificationsFromFile(File file) throws IOException {
        Properties properties = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), CONFIG_ENCODING);){
            properties.load(reader);
        }
        List<BundlesVersionDiscovery.PluginIdentification> pluginIdentifications = properties.entrySet().stream().map(entry -> new BundlesVersionDiscovery.PluginIdentification((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        return pluginIdentifications;
    }
}

