/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.ParentlessAssociatedItem;
import com.atlassian.jira.project.Project;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AffectedProject
extends ParentlessAssociatedItem {
    private final Long projectId;
    private final String projectName;

    public AffectedProject(Project project) {
        this.projectId = project.getId();
        this.projectName = project.getName();
    }

    @Nonnull
    public String getObjectName() {
        return this.projectName;
    }

    @Nullable
    public String getObjectId() {
        return Long.toString(this.projectId);
    }

    @Nonnull
    public AssociatedItem.Type getObjectType() {
        return AssociatedItem.Type.PROJECT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AffectedProject that = (AffectedProject)o;
        return Objects.equals(this.projectId, that.projectId);
    }

    public int hashCode() {
        return Objects.hash(this.projectId);
    }
}

