/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public class ChangedValuesBuilder {
    private final List<ChangedValue> changedValues = Lists.newArrayListWithCapacity((int)4);

    public ImmutableList<ChangedValue> build() {
        return ImmutableList.copyOf(this.changedValues);
    }

    public ChangedValuesBuilder add(String i18nKey, String from, String to) {
        this.changedValues.add(AuditEntitiesUtils.newChangedValue(i18nKey, from, to));
        return this;
    }

    public ChangedValuesBuilder add(String i18nKey, String to) {
        this.changedValues.add(AuditEntitiesUtils.newChangedValue(i18nKey, to));
        return this;
    }

    public ChangedValuesBuilder addIfDifferent(String i18nKey, String from, String to) {
        if (from == null && to != null || from != null && !from.equals(to)) {
            this.changedValues.add(AuditEntitiesUtils.newChangedValue(i18nKey, from, to));
        }
        return this;
    }
}

