/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.auditing.BufferingAuditService;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.event.ComponentManagerStartedEvent;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@AuditExceptionSafe
public class DefaultBufferingAuditService
implements BufferingAuditService {
    private static final Logger log = LoggerFactory.getLogger(DefaultBufferingAuditService.class);
    private static final int MAX_QUEUE_CAPACITY = 512;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    @GuardedBy(value="lock")
    private volatile boolean containerStarted = false;
    @GuardedBy(value="lock")
    private final BlockingQueue<Supplier<AuditEvent>> queue = new ArrayBlockingQueue<Supplier<AuditEvent>>(512);
    private final ComponentReference<AuditService> auditServiceRef = ComponentAccessor.getComponentReference(AuditService.class);

    public DefaultBufferingAuditService(EventPublisher eventPublisher) {
        eventPublisher.register((Object)this);
    }

    @EventListener
    @ThrowSafe
    public void onComponentManagerStartedEvent(ComponentManagerStartedEvent ignore) {
        try {
            this.lock.writeLock().lock();
            if (!this.containerStarted) {
                this.containerStarted = true;
                log.debug("Component Manager is ready. Dumping accumulated queue. Queue size: '{}'", (Object)this.queue.size());
                while (!this.queue.isEmpty()) {
                    this.auditImmediately((AuditEvent)((Supplier)this.queue.poll()).get());
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    @ThrowSafe
    public void auditOrPutToQueue(Supplier<AuditEvent> eventSupplier) {
        try {
            if (this.lock.readLock().tryLock(10L, TimeUnit.SECONDS)) {
                if (this.containerStarted) {
                    this.auditImmediately(eventSupplier.get());
                } else {
                    this.queue.add(eventSupplier);
                    log.debug("Cannot audit event because Component Manager is not yet ready. Event was put in the queue. Queue size: '{}'", (Object)this.queue.size());
                }
            } else {
                log.error("Failed to obtain lock. The event will not be audited");
            }
        }
        catch (InterruptedException e) {
            log.error("Failed to audit event due to interrupted exception", (Throwable)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void auditImmediately(AuditEvent event) {
        ((AuditService)this.auditServiceRef.get()).audit(event);
    }
}

