/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.core.AuditServiceFactory;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.auditing.PreAuditEnriching;
import com.atlassian.jira.config.FeatureManager;
import java.util.Objects;
import javax.annotation.Nonnull;

public class PrecursorAuditService
implements AuditService {
    private final FeatureManager featureManager;
    private final AuditService delegate;
    private final PreAuditEnriching preAuditEnriching;

    public PrecursorAuditService(FeatureManager featureManager, AuditServiceFactory auditServiceFactory, PreAuditEnriching preAuditEnriching) {
        this.featureManager = Objects.requireNonNull(featureManager);
        this.delegate = Objects.requireNonNull(auditServiceFactory).create();
        this.preAuditEnriching = Objects.requireNonNull(preAuditEnriching);
    }

    public void audit(@Nonnull AuditEvent auditEvent) {
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ADVANCED_AUDIT_LOG)) {
            this.delegate.audit(this.preAuditEnriching.enrich(auditEvent));
        }
    }
}

